/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.array;

import electric.util.Value;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.array.ArrayType;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaElement;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaLocations;
import java.io.IOException;
import java.lang.reflect.Array;

public class LiteralArrayType
extends ArrayType {
    private SchemaElement member;
    private static boolean writeArrayType = false;

    public LiteralArrayType(Namespaces namespaces, Class javaClass) throws SchemaException {
        super(namespaces, javaClass);
        Class<?> memberClass = javaClass.getComponentType();
        Type memberType = namespaces.getTypeWithJavaClass(memberClass);
        this.member = new SchemaElement(this.getSchema(), "i", memberType);
        this.member.setQualify(true);
        this.member.setMaxOccurs(Integer.MAX_VALUE);
        this.member.setMinOccurs(0);
    }

    public LiteralArrayType(Schema schema, String name, Element member) throws SchemaException {
        super(schema, name);
        this.member = new SchemaElement(this, member);
    }

    public void writeSchema(Element schema) throws SchemaException {
        String xsdPrefix = Type.getXSDPrefix(schema);
        if (!this.member.getType().getNamespace().equals(this.getNamespace()) && !this.member.getType().useAnonymous()) {
            SchemaLocations.appendImport(schema, this.member.getType().getNamespace(), null);
        }
        Element complexType = schema.addElement(xsdPrefix, "complexType");
        complexType.setAttribute("name", this.getName());
        Element element = complexType.addElement(xsdPrefix, "sequence");
        this.member.writeSchema(element);
    }

    public Type getComponentType() throws SchemaException {
        return this.member.getType();
    }

    public void writeType(IWriter writer) throws IOException {
        writer.writeType(this);
    }

    public static boolean isWriteArrayType() {
        return writeArrayType;
    }

    public static void setWriteArrayType(boolean writeArrayType) {
        LiteralArrayType.writeArrayType = writeArrayType;
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        Type type = this.getComponentType();
        int dimension = Array.getLength(object);
        if (writeArrayType) {
            String soapPrefix = writer.getElement().getPrefix("http://schemas.xmlsoap.org/soap/encoding/", "soapenc");
            writer.writeAttribute(soapPrefix, "arrayType", type.getName(writer.getElement()) + "[]");
        }
        String prefix = writer.getElement().getPrefix(this.getNamespace());
        int i = 0;
        while (i < dimension) {
            if (this.member.isQualify()) {
                writer.writeObject(prefix, this.member.getName(), Array.get(object, i), type);
            } else {
                writer.writeObject(this.member.getName(), Array.get(object, i), type);
            }
            ++i;
        }
    }

    public void readObject(IReader reader, Value value) throws IOException {
        Type runtimeComponentType = this.getComponentType();
        int dimension = reader.getElement().getElements(this.member.getName()).size();
        Class javaClass = null;
        try {
            javaClass = runtimeComponentType.getJavaClassWithCheck();
        }
        catch (ClassNotFoundException exception) {
            throw new IOException(exception.toString());
        }
        Object array = Array.newInstance(javaClass, dimension);
        value.setObject(array);
        IReader[] readers = reader.getReaders(this.member.getName());
        int i = 0;
        while (i < readers.length) {
            Array.set(array, i, readers[i].readValue(runtimeComponentType).getObject());
            ++i;
        }
    }
}

