/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.collections.apache;

import electric.util.Value;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Type;
import electric.xml.io.schema.SchemaException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class HashMapType
extends Type {
    static /* synthetic */ Class class$java$lang$Object;

    public HashMapType() {
        this.setInhibit(true);
    }

    public void writeSchema(Element schema) throws SchemaException {
        String xsdPrefix = Type.getXSDPrefix(schema);
        Element complexType = schema.addElement(xsdPrefix, "complexType");
        complexType.setAttribute("name", "hashmap");
        Element sequence = complexType.addElement(xsdPrefix, "sequence");
        Element element = sequence.addElement(xsdPrefix, "element");
        element.setAttribute("name", "item");
        element.setAttribute("minOccurs", "0");
        element.setAttribute("maxOccurs", "unbounded");
        Element subType = element.addElement(xsdPrefix, "complexType");
        Element subSequence = subType.addElement(xsdPrefix, "sequence");
        Element key = subSequence.addElement(xsdPrefix, "element");
        key.setAttribute("name", "key");
        key.setAttribute("type", this.getName(key, class$java$lang$Object == null ? (class$java$lang$Object = HashMapType.class$("java.lang.Object")) : class$java$lang$Object));
        Element value = subSequence.addElement(xsdPrefix, "element");
        value.setAttribute("name", "value");
        value.setAttribute("type", this.getName(value, class$java$lang$Object == null ? (class$java$lang$Object = HashMapType.class$("java.lang.Object")) : class$java$lang$Object));
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        HashMap hashmap = (HashMap)object;
        Iterator entries = hashmap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            IWriter itemWriter = writer.writeElement("item");
            itemWriter.writeObject("key", entry.getKey());
            itemWriter.writeObject("value", entry.getValue());
        }
    }

    public void readObject(IReader reader, Value value) throws IOException {
        IReader[] readers = reader.getReaders("item");
        HashMap<Object, Object> map = (HashMap<Object, Object>)value.getObject();
        if (map == null) {
            map = new HashMap<Object, Object>();
            value.setObject(map);
        }
        int i = 0;
        while (i < readers.length) {
            IReader itemReader = readers[i];
            Object key = itemReader.readObject("key");
            Object theValue = itemReader.readObject("value");
            map.put(key, theValue);
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

