/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.encoded;

import electric.util.Value;
import electric.util.array.ArrayUtil;
import electric.xml.Attribute;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.io.IReader;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.encoded.Values;
import electric.xml.io.schema.ISchemaConstants;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import electric.xml.io.simple.AnyType;
import java.io.IOException;
import java.util.Hashtable;

public final class EncodedReader
implements IReader,
ISchemaConstants {
    private static final AnyType anyType = new AnyType();
    private Hashtable elementsRead = new Hashtable();
    private Element element;
    private Element root;
    private Namespaces namespaces;
    private Values values;
    private Hashtable properties;
    private String encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";

    public EncodedReader(Document document) {
        this(document.getRoot());
    }

    public EncodedReader(Element element) {
        this(element, "http://schemas.xmlsoap.org/soap/encoding/");
    }

    public EncodedReader(Element element, String encodingStyle) {
        this(element, new Namespaces(SchemaProperties.getDefaultSchema(), encodingStyle));
    }

    public EncodedReader(Element element, Namespaces namespaces) {
        this(element, namespaces, element);
    }

    public EncodedReader(Element element, Namespaces namespaces, Element root) {
        this.element = element;
        this.namespaces = namespaces;
        this.root = root;
        this.values = new Values();
        this.encodingStyle = namespaces.getEncodingStyle();
        this.followHref();
    }

    private EncodedReader(Element element, EncodedReader reader) {
        this.element = element;
        this.namespaces = reader.namespaces;
        this.root = reader.root;
        this.values = reader.values;
        this.encodingStyle = reader.encodingStyle;
        this.followHref();
    }

    private void followHref() {
        String href = this.element.getAttributeValue("href");
        if (href == null && "http://www.w3.org/2003/05/soap-encoding".equals(this.encodingStyle)) {
            href = this.element.getAttributeValue("ref");
        }
        if (href == null) {
            return;
        }
        String id = href.charAt(0) == '#' ? href.substring(1) : href;
        String xsi = this.element.getNamespace("xsi");
        Element referencedElement = this.values.getElementWithId(this.root, id);
        if (referencedElement == null) {
            return;
        }
        Attribute typeAttr = this.element.getAttributeObject(xsi, "type");
        this.element = referencedElement;
        if (typeAttr != null && this.element.getAttributeObject(xsi, "type") == null) {
            this.element.setAttribute(typeAttr);
        }
    }

    public String getVersion() {
        return this.namespaces.getVersion();
    }

    public Document getDocument() {
        return this.element.getDocument();
    }

    public Element getElement() {
        return this.element;
    }

    public Element readElement(String name) {
        this.elementsRead.put(name, name);
        return this.element.getElement(name);
    }

    public Elements readElements(String name) {
        this.elementsRead.put(name, name);
        return this.element.getElements(name);
    }

    public Elements readElements() {
        return this.element.getElements();
    }

    public Element[] getUnreadElements() {
        Element[] returnValue = new Element[]{};
        Elements elements = this.element.getElements();
        while (elements.hasMoreElements()) {
            if (this.elementsRead.contains(elements.next().getName())) continue;
            returnValue = (Element[])ArrayUtil.addElement(returnValue, elements.current());
        }
        return returnValue;
    }

    public String readName() {
        return this.element.getName();
    }

    public Attribute readAttribute(String name) {
        return this.element.getAttributeObject(name);
    }

    public String readAttributeValue(String name) {
        return this.element.getAttributeValue(name);
    }

    public boolean isNil() {
        return this.element.getAttribute("nil") != null || this.element.getAttribute("null") != null;
    }

    public IReader getReaderAt(int index) {
        return new EncodedReader(this.element.getElementAt(index), this);
    }

    public IReader getReader(String name) {
        Element child = this.element.getElement(name);
        return child == null ? null : new EncodedReader(child, this);
    }

    public IReader[] getReaders(String name) {
        return this.getReaders(this.element.getElements(name));
    }

    public IReader[] getReaders() {
        return this.getReaders(this.element.getElements());
    }

    public IReader[] getRemainingReaders() {
        IReader[] returnValue = new IReader[]{};
        Elements elements = this.element.getElements();
        while (elements.hasMoreElements()) {
            if (this.elementsRead.contains(elements.next().getName())) continue;
            returnValue = (IReader[])ArrayUtil.addElement(returnValue, new EncodedReader(elements.current(), this));
        }
        return returnValue;
    }

    private IReader[] getReaders(Elements elements) {
        IReader[] readers = new EncodedReader[elements.size()];
        int i = 0;
        while (i < readers.length) {
            readers[i] = new EncodedReader(elements.next(), this);
            ++i;
        }
        return readers;
    }

    public String readText() {
        String text = this.element.getTextString();
        return text != null ? text : null;
    }

    public boolean readBoolean() throws IOException {
        try {
            return this.element.getBoolean();
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public boolean readBoolean(String name) throws IOException {
        try {
            return this.element.getBoolean(name);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public byte readByte() throws IOException {
        try {
            return this.element.getByte();
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public byte readByte(String name) throws IOException {
        try {
            return this.element.getByte(name);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public char readChar() throws IOException {
        try {
            return this.element.getChar();
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public char readChar(String name) throws IOException {
        try {
            return this.element.getChar(name);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public short readShort() throws IOException {
        try {
            return this.element.getShort();
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public short readShort(String name) throws IOException {
        try {
            return this.element.getShort(name);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public int readInt() throws IOException {
        try {
            return this.element.getInt();
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public int readInt(String name) throws IOException {
        try {
            return this.element.getInt(name);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public long readLong() throws IOException {
        try {
            return this.element.getLong();
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public long readLong(String name) throws IOException {
        try {
            return this.element.getLong(name);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public float readFloat() throws IOException {
        try {
            return this.element.getFloat();
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public float readFloat(String name) throws IOException {
        try {
            return this.element.getFloat(name);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public double readDouble() throws IOException {
        try {
            return this.element.getDouble();
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public double readDouble(String name) throws IOException {
        try {
            return this.element.getDouble(name);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public String readString() {
        return this.readString(this.element);
    }

    public String readString(String name) {
        Element namedElement = this.element.getElement(name);
        return namedElement == null ? null : this.readString(namedElement);
    }

    private String readString(Element element) {
        String text = element.getTextString();
        return text != null ? text : "";
    }

    public Type getType() throws SchemaException {
        String xsiType = this.element.getAttributeValue("type");
        if (xsiType != null) {
            return this.namespaces.getTypeWithQName(this.element, xsiType);
        }
        if (this.element.getAttributeValue("arrayType") != null) {
            String[] names = Element.getParts(this.element.getAttributeValue("arrayType"));
            return this.namespaces.getTypeWithQName(this.element.getNamespace(names[0]), names[1]);
        }
        return null;
    }

    public Object readObject() throws IOException {
        return this.readValue().getObject();
    }

    public Object readObject(String name) throws IOException {
        return this.getReader(name).readObject();
    }

    public Object readObject(Type type) throws IOException {
        return this.readValue(type).getObject();
    }

    public Object readObject(Class type) throws IOException {
        return this.readValue(this.namespaces.getTypeWithJavaClass(type)).getObject();
    }

    public Object readObject(String name, Type type) throws IOException {
        return this.getReader(name).readObject(type);
    }

    public void addObject(String id, Object attachment) {
        this.values.newValue(id).setObject(attachment);
    }

    public Object getObject(String id) {
        return this.values.getValue(id);
    }

    public Value readValue() throws IOException {
        return this.readValue(anyType);
    }

    public Value readValue(Type type) throws IOException {
        return this.isNil() ? Value.NULL : this.read(type);
    }

    private Value read(Type type) throws IOException {
        String id;
        Type runtimeType = this.getType();
        if (runtimeType != null) {
            type = runtimeType;
        }
        if ((id = this.readAttributeValue("id")) != null) {
            Value value = this.values.getValue(id);
            if (value == null) {
                value = this.values.newValue(id);
                type.readObject(this, value);
            }
            return value;
        }
        String href = this.readAttributeValue("href");
        if (href != null) {
            Value value = this.values.getValue(href);
            if (value != null) {
                return value;
            }
            throw new IllegalArgumentException("could not find element with id " + href + " in message");
        }
        Value value = new Value();
        type.readObject(this, value);
        return value;
    }

    public void addProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties == null ? null : this.properties.get(key);
    }
}

