/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.schema;

import electric.util.Value;
import electric.util.java.JavaSource;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.string.Strings;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.accessors.UnboundAccessor;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaEntry;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import electric.xml.io.simple.AnyType;
import electric.xml.io.simple.StringType;
import electric.xml.xpath.TMEXPath;
import java.io.IOException;
import java.lang.reflect.Array;

public final class SchemaElement
extends SchemaEntry {
    private static String ANONYMOUS_SUFFIX = "_TYPE";
    private boolean nillable;
    private boolean qualify;
    private String javaName;
    private Class javaClass;
    private boolean disableTypeOmission;
    private boolean bare;

    public SchemaElement(Namespaces namespaces, String namespace, String name, Type type) {
        super(namespaces.findSchema(namespace), name, type);
        this.qualify = this.schema.getQualifyElements();
    }

    public SchemaElement(Schema schemaObject, Element schemaElement) throws SchemaException {
        super(schemaObject);
        this.readSchema(schemaElement);
    }

    public SchemaElement(Schema schema, String name, Type type) throws SchemaException {
        super(schema, name, type);
    }

    public SchemaElement(Type parentType, Element schema) throws SchemaException {
        super(parentType);
        this.readSchema(schema);
    }

    public SchemaElement(Type parentType, String name, Type type) {
        super(parentType);
        this.name = name;
        this.type = type;
        this.nillable = type.isMultiReference() || type instanceof StringType;
    }

    public SchemaElement(String name, Type type, boolean qualify) {
        super(type.getSchema());
        this.name = name;
        this.type = type;
        this.qualify = qualify;
        this.nillable = type.isMultiReference() || type instanceof StringType;
    }

    public String toString() {
        return "SchemaElement( " + this.name + " )";
    }

    public boolean getNillable() {
        return this.nillable;
    }

    public void setNillable(boolean nillable) {
        this.nillable = nillable;
    }

    public boolean getBare() {
        return this.bare;
    }

    public void setBare(boolean bare) {
        this.bare = bare;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public synchronized Type getType() throws SchemaException {
        if (this.type != null) {
            return this.type;
        }
        return super.getType();
    }

    public synchronized String getJavaName() throws SchemaException {
        if (this.javaName != null) {
            return this.javaName;
        }
        this.javaName = this.maxOccurs > 1 ? this.getType().getJavaName() + "[]" : this.getType().getJavaName();
        return this.javaName;
    }

    public synchronized Class getJavaClass() throws SchemaException {
        if (this.javaClass != null) {
            return this.javaClass;
        }
        this.javaClass = this.getType().getJavaClass();
        if (this.maxOccurs > 1 && this.javaClass != null) {
            this.javaClass = Array.newInstance(this.javaClass, 0).getClass();
        }
        return this.javaClass;
    }

    public void writeJava(JavaSource source) throws SchemaException {
        this.accessor.writeJava(source);
    }

    public void readSchema(Element schema) throws SchemaException {
        String max;
        this.name = schema.getAttributeValue("name");
        String min = schema.getAttributeValue("minOccurs");
        if (min != null) {
            this.minOccurs = Integer.parseInt(min);
        }
        if ((max = schema.getAttributeValue("maxOccurs")) != null) {
            this.maxOccurs = max.equals("unbounded") || max.equals("*") ? Integer.MAX_VALUE : Integer.parseInt(max);
        }
        String nillableString = schema.getAttributeValue("nillable");
        this.nillable = Strings.getBoolean(nillableString, false);
        String form = schema.getAttributeValue("form");
        this.qualify = form == null ? this.getSchema().getQualifyElements() : form.equals("qualified");
        this.setType(schema);
        this.accessor = new UnboundAccessor(this, this.name, schema);
    }

    private void setType(Element schema) throws SchemaException {
        this.typeQName = schema.getAttributeValue("type");
        if (this.typeQName != null) {
            this.typeQName = schema.getQName(this.typeQName);
            return;
        }
        this.refQName = schema.getAttributeValue("ref");
        if (this.refQName != null) {
            if (this.name == null) {
                this.name = Element.getParts(this.refQName)[1];
            }
            this.refQName = schema.getQName(this.refQName);
            return;
        }
        Element anonymousElement = schema.getElement("complexType");
        if (anonymousElement == null) {
            anonymousElement = schema.getElement("simpleType");
        }
        if (anonymousElement == null) {
            this.type = new AnyType();
            return;
        }
        this.type = this.schema.getNamespaces().getTypeWithSchema(this.schema.getTargetNamespace(), this.name + ANONYMOUS_SUFFIX, anonymousElement);
        this.type.setAnonymous(true);
        this.schema.addSchemaType(this.type);
    }

    public void writeSchema(Element schema) throws SchemaException {
        this.writeSchema(schema, false);
    }

    public void writeSchema(Element schema, boolean annotated) throws SchemaException {
        this.appendImport(schema);
        String xsdPrefix = schema.getPrefix(SchemaProperties.getDefaultSchema(), "xsd");
        Element element = schema.addElement(xsdPrefix, "element");
        element.setAttribute("name", this.name);
        Type type = this.getType();
        if (this.minOccurs != 1) {
            element.setAttribute("minOccurs", Integer.toString(this.minOccurs));
        }
        if (this.maxOccurs == Integer.MAX_VALUE) {
            element.setAttribute("maxOccurs", "unbounded");
        } else if (this.maxOccurs != 1) {
            element.setAttribute("maxOccurs", Integer.toString(this.maxOccurs));
        }
        if (this.nillable) {
            element.setAttribute("nillable", "true");
        }
        if (this.qualify != this.getSchema().getQualifyElements()) {
            element.setAttribute("form", this.qualify ? "qualified" : "unqualified");
        }
        if (annotated && this.accessor != null) {
            this.accessor.annotateSchema(element);
        }
        if (!this.useAnonymous && !type.useAnonymous()) {
            element.setAttribute("type", type.getName(element));
        } else {
            type.writeSchema(element, annotated);
        }
    }

    public void appendSchema(Element root, boolean annotated) throws SchemaException {
        TMEXPath xpath;
        Element schemaElement = null;
        if (this.getNamespace() == null || this.getNamespace().equals("")) {
            xpath = new TMEXPath("//schema");
            Elements elements = root.getRoot().getElements(xpath);
            while (elements.hasMoreElements()) {
                Element next = elements.next();
                if (next.hasAttribute("targetNamespace")) continue;
                schemaElement = next;
                break;
            }
        } else {
            xpath = new TMEXPath("//schema[@targetNamespace='" + this.getNamespace() + "']");
            schemaElement = root.getRoot().getElement(xpath);
        }
        if (schemaElement == null) {
            schemaElement = root.addElement();
            String prefix = schemaElement.getPrefix(this.schema.getVersion(), "xsd");
            if (this.schema.getQualifyElements()) {
                schemaElement.setAttribute("elementFormDefault", "qualified");
            }
            if (this.schema.getQualifyAttributes()) {
                schemaElement.setAttribute("attributeFormDefault", "qualified");
            }
            if (this.getNamespace() != null && !this.getNamespace().equals("")) {
                schemaElement.setAttribute("targetNamespace", this.getNamespace());
            }
            schemaElement.setName(prefix, "schema");
        }
        this.writeSchema(schemaElement, annotated);
    }

    public void setDisableTypeOmission(boolean flag) {
        this.disableTypeOmission = flag;
    }

    public boolean getDisableTypeOmission() {
        return this.disableTypeOmission;
    }

    public boolean isQualify() {
        return this.qualify;
    }

    public void setQualify(boolean qualify) {
        this.qualify = qualify;
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        try {
            Object value = this.accessor.get(object);
            String prefix = null;
            if (this.qualify) {
                prefix = writer.getElement().getPrefix(this.getNamespace());
            }
            if (value == null && this.minOccurs == 0) {
                return;
            }
            Type type = this.getType();
            if (this.maxOccurs == 1) {
                if (this.disableTypeOmission || writer.getTypeOmissionDisabled()) {
                    writer.writeObjectDisablingTypeOmission(prefix, this.name, value, type);
                } else {
                    writer.writeObject(prefix, this.name, value, type);
                }
            } else {
                int length = Array.getLength(value);
                if (this.disableTypeOmission || writer.getTypeOmissionDisabled()) {
                    int i = 0;
                    while (i < length) {
                        writer.writeObjectDisablingTypeOmission(prefix, this.name, Array.get(value, i), type);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < length) {
                        writer.writeObject(prefix, this.name, Array.get(value, i), type);
                        ++i;
                    }
                }
            }
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
            throw new IOException(exception.toString());
        }
    }

    public void readObject(IReader reader, Value value) throws IOException {
        if (this.bare) {
            this.readObjectBare(reader, value);
        } else {
            this.readObjectWrapped(reader, value);
        }
    }

    private void readObjectWrapped(IReader reader, Value value) throws IOException {
        if (reader.getProperty(this.name) != null) {
            return;
        }
        try {
            Type type = this.getType();
            if (this.maxOccurs == 1) {
                IReader fieldReader = reader.getReader(this.name);
                if (fieldReader != null) {
                    this.accessor.set(value, fieldReader.readValue(type));
                }
            } else {
                Class javaClass = this.getJavaClass();
                if (javaClass == null) {
                    throw new IOException(type.getQName() + " has no mapping to a java class");
                }
                IReader[] readers = reader.getReaders(this.name);
                Object array = Array.newInstance(javaClass.getComponentType(), readers.length);
                int i = 0;
                while (i < readers.length) {
                    Array.set(array, i, readers[i].readObject(type));
                    ++i;
                }
                this.accessor.set(value, new Value(array));
            }
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
            throw new IOException(exception.toString());
        }
    }

    private void readObjectBare(IReader reader, Value value) throws IOException {
        try {
            if (reader != null) {
                this.accessor.set(value, reader.readValue(this.getType()));
            }
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
            throw new IOException(exception.toString());
        }
    }
}

