/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.tools;

import electric.util.array.ArrayUtil;
import electric.util.file.FileUtil;
import electric.util.java.JavaSource;
import electric.util.product.Product;
import electric.util.reflect.Wrappers;
import electric.util.string.Strings;
import electric.xml.io.simple.EnumerationUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Enum {
    private static String className = null;
    private static String[] values = new String[0];
    private static Class baseClass = class$java$lang$String == null ? (class$java$lang$String = Enum.class$("java.lang.String")) : class$java$lang$String;
    private static String dir = "";
    static /* synthetic */ Class class$java$lang$String;

    public static void main(String[] args) {
        if (args.length == 0) {
            Enum.printUsage();
            return;
        }
        try {
            Enum.processArgs(args);
            Product.startup();
            Enum.enum();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Enum.printUsage();
            System.exit(-1);
        }
    }

    private static void printUsage() {
        System.out.println("usage: enum [-h] classname value1 value2 .. valueN [-d directory] [-t type]");
        System.out.println();
        System.out.println("where:");
        System.out.println("  classname    = name of java class");
        System.out.println("  valueN       = Nth possible enumeration value");
        System.out.println("  -d directory = output directory, '.' by default");
        System.out.println("  -h           = print help and exit");
        System.out.println("  -t type      = type of enum, String by default");
        System.out.println();
        System.out.println("examples:");
        System.out.println();
        System.out.println("enum mypackage.Color red green blue");
        System.out.println("  creates mypackage.Color class with 3 strings");
        System.out.println();
        System.out.println("enum Countdown 3 2 1 -t int");
        System.out.println("  creates Countdown class with 3 ints");
        System.out.println();
        System.out.println("enum Letters a b \" \" -t char");
        System.out.println("  creates Letters class with 3 chars, including a space");
    }

    private static void processArgs(String[] args) throws Throwable {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                if (className == null) {
                    className = arg;
                } else {
                    values = (String[])ArrayUtil.addElement(values, arg);
                }
            } else {
                if (arg.length() == 1) {
                    throw new IllegalArgumentException("a plain - is not a valid argument");
                }
                switch (arg.charAt(1)) {
                    case 'd': {
                        dir = Strings.getString("d", args, ++i);
                        if (dir.endsWith("/") || dir.endsWith("\\")) break;
                        dir = dir + File.separator;
                        break;
                    }
                    case 'h': {
                        Enum.printUsage();
                        System.exit(-1);
                    }
                    case 't': {
                        String baseClassName = Strings.getString("t", args, ++i);
                        baseClass = baseClassName.endsWith("String") ? (class$java$lang$String == null ? Enum.class$("java.lang.String") : class$java$lang$String) : Wrappers.getPrimitiveClass(baseClassName);
                        if (baseClass != null) break;
                        throw new IllegalArgumentException("cannot find class with name " + baseClassName);
                    }
                    default: {
                        throw new IllegalArgumentException("illegal argument " + arg.charAt(1));
                    }
                }
            }
            ++i;
        }
        if (className == null) {
            throw new IllegalArgumentException("missing class name");
        }
    }

    private static void enum() throws IOException {
        String localName = Strings.getLocalJavaName(className);
        String packageName = Strings.getJavaPackage(className);
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        writer.println(Enum.getDescription());
        JavaSource source = new JavaSource();
        EnumerationUtil.writeJava(source, localName, packageName, baseClass, values);
        source.write(writer);
        writer.close();
        FileUtil.saveFile(dir, localName, stringWriter.toString(), ".java");
    }

    private static String getDescription() {
        return "// generated by " + Product.getShortDescription() + " (enum) on " + new Date();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

