/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie;

import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.bonnie.LuceneException;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReadWriteLock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantReadWriteLock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexUtils;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class LuceneConnection
implements ILuceneConnection {
    public static final Category LOG = Category.getInstance((Class)LuceneConnection.class);
    public static final int WRITER_DEFAULT = 1;
    public static final int WRITER_INTERACTIVE = 2;
    public static final int WRITER_BATCH = 4;
    public static final String REINDEXING_FILENAME = ".reindexing";
    protected Analyzer analyzerForIndexing;
    protected boolean searcherOpensNewReader = true;
    private File indexDir = null;
    private Directory directory = null;
    private final ReadWriteLock sync = new ReentrantReadWriteLock();
    private final Object createLock = new Object();
    private final ILuceneConnection.Configuration configuration;
    private IndexReader reader = null;
    private IndexWriter writer = null;
    private long readerVersion = -1L;
    private boolean alwaysUnlock = true;

    public LuceneConnection() {
        this.configuration = DEFAULT_CONFIGURATION;
    }

    public LuceneConnection(File location, Analyzer analyzerForIndexing) {
        this(location, analyzerForIndexing, DEFAULT_CONFIGURATION);
    }

    public LuceneConnection(File location, Analyzer analyzerForIndexing, ILuceneConnection.Configuration configuration) {
        this.indexDir = location;
        this.analyzerForIndexing = analyzerForIndexing;
        this.configuration = configuration;
    }

    public LuceneConnection(Directory directory, Analyzer analyzerForIndexing) {
        this.directory = directory;
        this.analyzerForIndexing = analyzerForIndexing;
        this.configuration = DEFAULT_CONFIGURATION;
    }

    public LuceneConnection(Directory directory, Analyzer analyzerForIndexing, ILuceneConnection.Configuration configuration) {
        this.directory = directory;
        this.analyzerForIndexing = analyzerForIndexing;
        this.configuration = configuration;
    }

    public void withSearch(ILuceneConnection.SearcherAction action) throws LuceneException {
        IndexSearcher searcher = null;
        this.grabReadLock();
        try {
            searcher = this.getSearcher();
            if (action.perform(searcher)) {
                searcher.close();
            }
        }
        catch (Throwable e) {
            if (searcher != null) {
                try {
                    searcher.close();
                }
                catch (Throwable t) {
                    LOG.debug((Object)t);
                }
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new LuceneException(e);
        }
        finally {
            this.releaseReadLock();
        }
    }

    protected IndexSearcher getSearcher() throws IOException {
        if (this.searcherOpensNewReader) {
            return new IndexSearcher(this.getDirectory());
        }
        return new IndexSearcher(this.getReader());
    }

    public Object withReader(ILuceneConnection.ReaderAction action) throws LuceneException {
        Object result = null;
        this.grabReadLock();
        try {
            IndexReader reader = this.getReader();
            result = action.perform(reader);
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
        finally {
            this.releaseReadLock();
        }
        return result;
    }

    public void withReaderAndDeletes(ILuceneConnection.ReaderAction action) throws LuceneException {
        this.grabWriteLock();
        try {
            this.unlockIfNeeded();
            this.closeWriter();
            IndexReader reader = this.getReader();
            action.perform(reader);
            this.closeReader();
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void withWriter(ILuceneConnection.WriterAction action) throws LuceneException {
        this.withWriter(action, 2);
    }

    public void withWriter(ILuceneConnection.WriterAction action, int flags) throws LuceneException {
        this.grabWriteLock();
        try {
            this.unlockIfNeeded();
            IndexWriter writer = this.getWriter(flags);
            action.perform(writer);
            if (!this.isReIndexing()) {
                this.closeWriter();
            }
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withDeleteAndWrites(ILuceneConnection.ReaderAction readerAction, ILuceneConnection.WriterAction writerAction) throws LuceneException {
        this.grabWriteLock();
        try {
            this.withReaderAndDeletes(readerAction);
            this.withWriter(writerAction);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void withBatchUpdate(ILuceneConnection.BatchUpdateAction action) {
        this.grabWriteLock();
        try {
            action.perform();
        }
        catch (Exception e) {
            throw new LuceneException(e);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void optimize() throws LuceneException {
        this.grabWriteLock();
        try {
            IndexWriter writer = this.getWriter();
            writer.optimize();
            this.closeWriter();
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void setSearcherOpensNewReader(boolean searcherOpensNewReader) {
        this.searcherOpensNewReader = searcherOpensNewReader;
    }

    private IndexWriter createAndConfigureWriter(int flags) throws LuceneException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(Thread.currentThread().getName() + "## opening writer"));
            }
            IndexWriter writer = new IndexWriter(this.getDirectory(), this.analyzerForIndexing, false);
            this.configureWriter(writer, flags);
            return writer;
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
    }

    void configureWriter(IndexWriter writer, int flags) {
        writer.setMaxFieldLength(this.configuration.getMaxFieldLength());
        writer.setUseCompoundFile(this.configuration.isCompoundIndexFileFormat());
        if (LuceneConnection.isSet(flags, 4)) {
            writer.setMergeFactor(this.configuration.getBatchMergeFactor());
            writer.setMaxBufferedDocs(this.configuration.getBatchMaxBufferedDocs());
            writer.setMaxMergeDocs(this.configuration.getBatchMaxMergeDocs());
        } else if (LuceneConnection.isSet(flags, 2)) {
            writer.setMergeFactor(this.configuration.getInteractiveMergeFactor());
            writer.setMaxBufferedDocs(this.configuration.getInteractiveMaxBufferedDocs());
            writer.setMaxMergeDocs(this.configuration.getInteractiveMaxMergeDocs());
        }
    }

    private static boolean isSet(int flags, int f) {
        return (flags & f) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushWriter() throws LuceneException {
        this.grabWriteLock();
        try {
            this.closeReader();
            this.closeWriter();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    protected final IndexReader getReader() throws LuceneException {
        Object object = this.createLock;
        synchronized (object) {
            try {
                if (this.reader == null) {
                    this.createIndexDirectory(false);
                    LOG.debug((Object)(Thread.currentThread().getName() + "##opening reader"));
                    this.readerVersion = IndexReader.getCurrentVersion((Directory)this.getDirectory());
                    this.reader = IndexReader.open((Directory)this.getDirectory());
                } else {
                    long v = IndexReader.getCurrentVersion((Directory)this.getDirectory());
                    if (v != this.readerVersion) {
                        this.createIndexDirectory(false);
                        LOG.debug((Object)(Thread.currentThread().getName() + "Refreshing reader"));
                        this.reader.close();
                        this.reader = IndexReader.open((Directory)this.getDirectory());
                        this.readerVersion = v;
                    }
                }
                return this.reader;
            }
            catch (IOException e) {
                throw new LuceneException(e);
            }
        }
    }

    protected IndexWriter getWriter() throws LuceneException {
        return this.getWriter(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexWriter getWriter(int flags) throws LuceneException {
        Object object = this.createLock;
        synchronized (object) {
            this.createIndexDirectory(false);
            this.closeReader();
            if (this.writer == null) {
                this.writer = this.createAndConfigureWriter(flags);
            }
            return this.writer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeWriter() {
        Object object = this.createLock;
        synchronized (object) {
            if (this.writer != null) {
                try {
                    IndexWriter writer = this.writer;
                    this.writer = null;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(Thread.currentThread().getName() + "##closing writer"));
                    }
                    writer.close();
                }
                catch (IOException e) {
                    LOG.error((Object)(Level.ERROR + "problem closing index writer" + e), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeReader() {
        Object object = this.createLock;
        synchronized (object) {
            if (this.reader != null) {
                try {
                    IndexReader reader = this.reader;
                    this.reader = null;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(Thread.currentThread().getName() + "##closing reader"));
                    }
                    reader.close();
                }
                catch (IOException e) {
                    LOG.error((Object)("problem closing index reader" + e), (Throwable)e);
                }
            }
        }
    }

    private void grabReadLock() throws LuceneException {
        this.sync.readLock().lock();
    }

    private void releaseReadLock() {
        this.sync.readLock().unlock();
    }

    private void grabWriteLock() throws LuceneException {
        this.sync.writeLock().lock();
    }

    private void releaseWriteLock() {
        this.sync.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.grabWriteLock();
            try {
                this.closeReader();
                this.closeWriter();
            }
            finally {
                this.releaseWriteLock();
            }
        }
        catch (LuceneException e) {
            LOG.error((Object)("problem closing lucene connection" + e));
        }
    }

    public boolean isReIndexing() throws IOException {
        return this.getDirectory().fileExists(REINDEXING_FILENAME);
    }

    public void setReIndexing(boolean b) throws IOException {
        if (!b) {
            if (this.isReIndexing()) {
                this.getDirectory().deleteFile(REINDEXING_FILENAME);
                this.closeWriter();
            }
        } else if (!this.isReIndexing()) {
            Directory directory = this.getDirectory();
            if (!directory.fileExists(REINDEXING_FILENAME)) {
                directory.createOutput(REINDEXING_FILENAME).close();
            } else {
                directory.touchFile(REINDEXING_FILENAME);
            }
        }
    }

    public void recreateIndexDirectory() {
        this.createIndexDirectory(true);
    }

    public IndexSearcher leakSearcher() {
        throw new UnsupportedOperationException("Not Implemented. Use withSearch method instead.");
    }

    protected boolean shouldCreateIndexDirectory() throws IOException {
        return !this.isIndexCreated();
    }

    private void createIndexDirectory(boolean forceCreate) {
        try {
            if (forceCreate || this.shouldCreateIndexDirectory()) {
                new IndexWriter(this.getDirectory(), null, true).close();
            }
        }
        catch (IOException e) {
            throw new LuceneException("Cannot create index directory", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateIndex() throws IOException {
        this.grabWriteLock();
        try {
            IndexUtils.truncateIndex(this.getDirectory());
        }
        catch (FileNotFoundException e) {
            this.recreateIndexDirectory();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    protected Directory getDirectory() throws IOException {
        if (this.directory == null) {
            File indexDir = this.getIndexDir();
            if (!indexDir.exists() && !indexDir.mkdir()) {
                throw new IOException("Unable to create index directory '" + indexDir.getAbsolutePath() + "'");
            }
            this.directory = FSDirectory.getDirectory((File)indexDir);
        }
        return this.directory;
    }

    public File getIndexDir() {
        return this.indexDir;
    }

    public void setIndexDir(String location) {
        this.indexDir = new File(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumDocs() {
        int count = -1;
        try {
            this.grabReadLock();
            count = this.getReader().numDocs();
        }
        finally {
            this.releaseReadLock();
        }
        return count;
    }

    public boolean isIndexCreated() {
        try {
            return IndexReader.indexExists((Directory)this.getDirectory());
        }
        catch (IOException e) {
            return false;
        }
    }

    public void unlockIfNeeded() throws IOException {
        if (this.alwaysUnlock) {
            IndexReader.unlock((Directory)this.getDirectory());
        }
    }

    public void setAlwaysUnlock(boolean alwaysUnlock) {
        this.alwaysUnlock = alwaysUnlock;
    }

    public class TempIndexWriterData {
        public final IndexWriter writer;
        public final Directory dir;
        public final File tmpIndexDir;

        public TempIndexWriterData(IndexWriter writer, Directory dir, File tmpIndexDir) {
            this.writer = writer;
            this.dir = dir;
            this.tmpIndexDir = tmpIndexDir;
        }
    }
}

