/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie;

import com.atlassian.bonnie.ConcurrentLuceneConnection;
import com.atlassian.bonnie.ILuceneConnection;
import java.io.File;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;

public class LuceneConnectionFactory {
    private static final LuceneConnectionFactory FACTORY = new LuceneConnectionFactory();

    public static LuceneConnectionFactory get() {
        return FACTORY;
    }

    public ILuceneConnection createLuceneConnection(String path, Analyzer analyzer, ILuceneConnection.Configuration configuration) {
        return new ConcurrentLuceneConnection(new File(path), analyzer, configuration);
    }

    public ILuceneConnection createLuceneConnection(Directory directory, Analyzer analyzer, ILuceneConnection.Configuration configuration) {
        return new ConcurrentLuceneConnection(directory, analyzer, configuration);
    }

    public ILuceneConnection createLuceneConnection(String path, Analyzer analyzer) {
        return this.createLuceneConnection(path, analyzer, ILuceneConnection.DEFAULT_CONFIGURATION);
    }

    public ILuceneConnection createLuceneConnection(Directory directory, Analyzer analyzer) {
        return this.createLuceneConnection(directory, analyzer, ILuceneConnection.DEFAULT_CONFIGURATION);
    }
}

