/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.search;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class SearchWordsLister {
    private static final String KEYWORDS_REGEX = "AND|NOT|OR";
    private List ignoredWords;
    private List searchWords;
    private Analyzer referenceAnalyzer = null;
    private Analyzer queryAnalyzer = null;

    public SearchWordsLister() {
        this.ignoredWords = new ArrayList();
        this.searchWords = new ArrayList();
        this.referenceAnalyzer = new StandardAnalyzer(new String[0]);
        this.queryAnalyzer = new StandardAnalyzer();
    }

    public SearchWordsLister(Analyzer referenceAnalyzer, Analyzer queryAnalyzer) {
        this.referenceAnalyzer = referenceAnalyzer;
        this.queryAnalyzer = queryAnalyzer;
    }

    public List getIgnoredWords() {
        return this.ignoredWords;
    }

    public List getSearchWords() {
        return this.searchWords;
    }

    public String getIgnoredWordsAsString() {
        return this.listToDelimitedString(this.ignoredWords, ", ");
    }

    public String getSearchWordsAsString() {
        return this.listToDelimitedString(this.searchWords, ", ");
    }

    private String listToDelimitedString(List list, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            buffer.append(list.get(i));
            if (i + 1 >= list.size()) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    public void parseQuery(String query) throws IOException {
        query = query.replaceAll(KEYWORDS_REGEX, "");
        TokenStream queryStream = this.queryAnalyzer.tokenStream(null, (Reader)new StringReader(query));
        TokenStream referenceStream = this.referenceAnalyzer.tokenStream(null, (Reader)new StringReader(query));
        Token token = queryStream.next();
        Token refToken = referenceStream.next();
        while (refToken != null && token != null) {
            String tokenText = refToken.termText();
            if (tokenText.equals(token.termText())) {
                this.searchWords.add(tokenText);
                token = queryStream.next();
            } else if (!this.ignoredWords.contains(tokenText)) {
                this.ignoredWords.add(tokenText);
            }
            refToken = referenceStream.next();
            if (token != null || refToken == null) continue;
            while (refToken != null) {
                if (this.ignoredWords.contains(refToken.termText())) {
                    this.ignoredWords.add(refToken.termText());
                }
                refToken = referenceStream.next();
            }
        }
    }
}

