/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.search.extractor;

import com.atlassian.bonnie.search.SearchableAttachment;
import com.atlassian.bonnie.search.extractor.BaseAttachmentContentExtractor;
import com.atlassian.bonnie.search.extractor.ExtractorException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Category;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class MsExcelContentExtractor
extends BaseAttachmentContentExtractor {
    public static final Category log = Category.getInstance((Class)MsExcelContentExtractor.class);
    private static final String[] CONTENT_TYPES = new String[]{"application/excel", "application/x-excel", "application/x-msexcel", "application/vnd.ms-excel"};
    private static final String[] EXTENSIONS = new String[]{"xls"};

    protected String[] getMatchingContentTypes() {
        return CONTENT_TYPES;
    }

    protected String[] getMatchingFileExtensions() {
        return EXTENSIONS;
    }

    protected String extractText(InputStream is, SearchableAttachment attachment) throws ExtractorException {
        StringBuffer content = new StringBuffer();
        DocumentInputStream din = null;
        try {
            POIFSFileSystem poifs = new POIFSFileSystem(is);
            din = poifs.createDocumentInputStream("Workbook");
            HSSFRequest req = new HSSFRequest();
            req.addListenerForAllRecords((HSSFListener)new ExcelEventListener(content));
            HSSFEventFactory factory = new HSSFEventFactory();
            factory.processEvents(req, (InputStream)din);
        }
        catch (IOException e) {
            try {
                throw new ExtractorException("Error reading content of Excel document: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(din);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)din);
        return content.toString();
    }

    private static class ExcelEventListener
    implements HSSFListener {
        private final StringBuffer buff;
        private SSTRecord sstrec;
        private static final char SPACE = ' ';

        public ExcelEventListener(StringBuffer buff) {
            this.buff = buff;
        }

        public void processRecord(Record record) {
            switch (record.getSid()) {
                case 515: {
                    NumberRecord numrec = (NumberRecord)record;
                    double numberValue = numrec.getValue();
                    if (this.isInteger(numberValue)) {
                        this.buff.append((int)numberValue).append(' ');
                        break;
                    }
                    this.buff.append(numberValue).append(' ');
                    break;
                }
                case 252: {
                    this.sstrec = (SSTRecord)record;
                    break;
                }
                case 253: {
                    LabelSSTRecord lrec = (LabelSSTRecord)record;
                    this.buff.append(this.sstrec.getString(lrec.getSSTIndex())).append(' ');
                }
            }
        }

        private boolean isInteger(double doubleValue) {
            double floored = Math.floor(doubleValue);
            return doubleValue - floored == 0.0;
        }
    }
}

