/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.search.extractor;

import java.io.ByteArrayOutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.record.CString;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.record.StyleTextPropAtom;
import org.apache.poi.hslf.record.TextBytesAtom;
import org.apache.poi.hslf.record.TextCharsAtom;
import org.apache.poi.hslf.record.TextHeaderAtom;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.util.LittleEndian;

public class PowerPointListener
implements POIFSReaderListener {
    private static Logger log = Logger.getLogger((Class)PowerPointListener.class);
    private final StringBuffer buffer;
    public static final Set IGNORED_TEXT;
    public static final Set IGNORED_PREFIXES;

    public PowerPointListener(StringBuffer buff) {
        this.buffer = buff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPOIFSReaderEvent(POIFSReaderEvent event) {
        block7: {
            try {
                if (!"PowerPoint Document".equals(event.getName())) break block7;
                DocumentInputStream dis = event.getStream();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    byte[] documentBytes = new byte[dis.available()];
                    int bytesRead = dis.read(documentBytes, 0, dis.available());
                    if (log.isDebugEnabled() && bytesRead != documentBytes.length) {
                        log.debug((Object)"Bytes read from powerpoint file != bytes available");
                    }
                    int pos = 0;
                    while ((pos = this.findTextRecords(pos, documentBytes)) != -1) {
                    }
                }
                finally {
                    dis.close();
                    bos.close();
                }
            }
            catch (Exception e) {
                log.error((Object)("Error extracting PowerPoint text: " + e), (Throwable)e);
            }
        }
    }

    public int findTextRecords(int startPos, byte[] documentBytes) {
        int newPos;
        int len = (int)LittleEndian.getUInt((byte[])documentBytes, (int)(startPos + 4));
        byte opt = documentBytes[startPos];
        int container = opt & 0xF;
        if (container == 15) {
            return startPos + 8;
        }
        long type = LittleEndian.getUShort((byte[])documentBytes, (int)(startPos + 2));
        TextRun textRun = null;
        if (type == (long)RecordTypes.TextBytesAtom.typeID) {
            TextBytesAtom tba = (TextBytesAtom)Record.createRecordForType((long)type, (byte[])documentBytes, (int)startPos, (int)(len + 8));
            textRun = new TextRun((TextHeaderAtom)null, tba, (StyleTextPropAtom)null);
        }
        if (type == (long)RecordTypes.TextCharsAtom.typeID) {
            TextCharsAtom tca = (TextCharsAtom)Record.createRecordForType((long)type, (byte[])documentBytes, (int)startPos, (int)(len + 8));
            textRun = new TextRun((TextHeaderAtom)null, tca, (StyleTextPropAtom)null);
        }
        if (type == (long)RecordTypes.CString.typeID) {
            CString cs = (CString)Record.createRecordForType((long)type, (byte[])documentBytes, (int)startPos, (int)(len + 8));
            this.appendText(cs.getText());
        }
        if (textRun != null) {
            String textRunAsText = textRun.getText();
            this.appendText(textRunAsText);
        }
        if ((newPos = startPos + 8 + len) > documentBytes.length - 8) {
            newPos = -1;
        }
        return newPos;
    }

    private void appendText(String textRunAsText) {
        if (log.isDebugEnabled()) {
            log.debug((Object)textRunAsText);
        }
        if (IGNORED_TEXT.contains(textRunAsText)) {
            return;
        }
        Iterator iterator = IGNORED_PREFIXES.iterator();
        while (iterator.hasNext()) {
            String prefix = (String)iterator.next();
            if (!textRunAsText.startsWith(prefix)) continue;
            return;
        }
        this.buffer.append(textRunAsText);
        this.buffer.append(" ");
    }

    static {
        HashSet<String> tempIgnoredText = new HashSet<String>(9);
        tempIgnoredText.add("*");
        tempIgnoredText.add("Microsoft PowerPoint Presentation");
        tempIgnoredText.add("Click to edit Master title style");
        tempIgnoredText.add("Click to edit Master subtitle style");
        tempIgnoredText.add("Click to edit Master text styles\nSecond level\nThird level\nFourth level\nFifth level");
        tempIgnoredText.add("Default Design");
        tempIgnoredText.add("Microsoft Excel Worksheet");
        tempIgnoredText.add("Worksheet");
        tempIgnoredText.add("MS Org Chart");
        IGNORED_TEXT = Collections.unmodifiableSet(tempIgnoredText);
        HashSet<String> tempIgnoredPrefixes = new HashSet<String>(9);
        tempIgnoredPrefixes.add("PowerPoint.Show.");
        tempIgnoredPrefixes.add("Excel.Sheet.");
        tempIgnoredPrefixes.add("___PPT");
        tempIgnoredPrefixes.add("MS Organization Chart ");
        tempIgnoredPrefixes.add("WordArt ");
        tempIgnoredPrefixes.add("MSWordArt.");
        tempIgnoredPrefixes.add("Microsoft WordArt ");
        tempIgnoredPrefixes.add("Microsoft WordArt ");
        tempIgnoredPrefixes.add("OrgPlusWOPX.");
        IGNORED_PREFIXES = Collections.unmodifiableSet(tempIgnoredPrefixes);
    }
}

