/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.search.extractor;

import com.atlassian.bonnie.LuceneException;
import com.atlassian.bonnie.LuceneUtils;
import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.bonnie.search.extractor.XmlClassConfigurations;
import com.atlassian.core.util.ObjectUtils;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class XmlConfiguredExtractor
implements Extractor {
    public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable) {
        XmlClassConfigurations.ClassConfiguration classConfig = XmlClassConfigurations.getClassConfiguration(ObjectUtils.getTrueClass((Object)searchable));
        if (classConfig != null) {
            Iterator iter = classConfig.getFieldConfigurations().iterator();
            while (iter.hasNext()) {
                XmlClassConfigurations.FieldConfiguration fieldConfiguration = (XmlClassConfigurations.FieldConfiguration)iter.next();
                String[] attributeNames = fieldConfiguration.getAttributeName().split(",");
                for (int i = 0; i < attributeNames.length; ++i) {
                    Object o = this.getContentOfAttribute(searchable, attributeNames[i]);
                    if (o.getClass().isArray()) {
                        this.indexArrayField(document, fieldConfiguration, o);
                        continue;
                    }
                    if (o instanceof Collection) {
                        this.indexCollectionField(document, fieldConfiguration, (Collection)o);
                        continue;
                    }
                    if (o instanceof Date && fieldConfiguration.getType().equals("Keyword")) {
                        this.indexDateField(document, fieldConfiguration, (Date)o);
                        continue;
                    }
                    if ("contentBody".equals(fieldConfiguration.getFieldName())) {
                        defaultSearchableText.append(String.valueOf(o));
                        continue;
                    }
                    this.indexStringField(document, fieldConfiguration, String.valueOf(o));
                }
            }
        }
    }

    private void indexDateField(Document doc, XmlClassConfigurations.FieldConfiguration fieldConfiguration, Date date) {
        Field field = new Field(fieldConfiguration.getFieldName(), LuceneUtils.dateToString(date), Field.Store.YES, Field.Index.UN_TOKENIZED);
        doc.add((Fieldable)field);
    }

    private void indexArrayField(Document doc, XmlClassConfigurations.FieldConfiguration fieldConfiguration, Object arr) {
        int length = Array.getLength(arr);
        for (int i = 0; i < length; ++i) {
            Object o = Array.get(arr, i);
            this.indexStringField(doc, fieldConfiguration, String.valueOf(o));
        }
    }

    private void indexCollectionField(Document doc, XmlClassConfigurations.FieldConfiguration fieldConfiguration, Collection collection) {
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            this.indexStringField(doc, fieldConfiguration, String.valueOf(o));
        }
    }

    private void indexStringField(Document doc, XmlClassConfigurations.FieldConfiguration fieldConfiguration, String strContent) {
        Field field;
        if (fieldConfiguration.getType().equals("Text")) {
            field = new Field(fieldConfiguration.getFieldName(), strContent, Field.Store.YES, Field.Index.TOKENIZED);
        } else if (fieldConfiguration.getType().equals("Keyword")) {
            field = new Field(fieldConfiguration.getFieldName(), strContent, Field.Store.YES, Field.Index.UN_TOKENIZED);
        } else if (fieldConfiguration.getType().equals("UnIndexed")) {
            field = new Field(fieldConfiguration.getFieldName(), strContent, Field.Store.YES, Field.Index.NO);
        } else if (fieldConfiguration.getType().equals("UnStored")) {
            field = new Field(fieldConfiguration.getFieldName(), strContent, Field.Store.NO, Field.Index.TOKENIZED);
        } else {
            throw new LuceneException("Unknown type for a field, fieldName=" + fieldConfiguration.getFieldName());
        }
        doc.add((Fieldable)field);
    }

    private Object getContentOfAttribute(Object obj, String attributeName) {
        try {
            String[] attributes = attributeName.split("\\.");
            Object o = null;
            for (int i = 0; i < attributes.length; ++i) {
                o = PropertyUtils.getProperty((Object)obj, (String)attributeName);
            }
            return o == null ? "" : o;
        }
        catch (IllegalAccessException iae) {
            throw new LuceneException("Couldn't get string content of attribute, as property accessor method for " + attributeName + " cannot be accessed");
        }
        catch (NoSuchMethodException e) {
            throw new LuceneException("Couldn't get string content of attribute, as no such property accessor method for " + attributeName + " exists");
        }
        catch (InvocationTargetException e) {
            throw new LuceneException("Calling property accessor method for attribute " + attributeName + " threw an exception", e);
        }
    }
}

