/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

public class IndexUtils {
    public static void truncateIndex(Directory dir) throws IOException {
        SegmentInfos segmentInfos = new SegmentInfos();
        segmentInfos.read(dir);
        Vector deletable = IndexUtils.readDeleteableFiles(dir);
        String[] indexfiles = dir.list();
        Iterator it = segmentInfos.iterator();
        while (it.hasNext()) {
            SegmentInfo si = (SegmentInfo)it.next();
            for (int i = 0; i < indexfiles.length; ++i) {
                if (!indexfiles[i].startsWith(si.name)) continue;
                deletable.add(indexfiles[i]);
            }
        }
        IndexUtils.writeDeleteableFiles(dir, deletable);
        segmentInfos.clear();
        segmentInfos.write(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Vector readDeleteableFiles(Directory directory) throws IOException {
        Vector<String> result = new Vector<String>();
        if (!directory.fileExists("deletable")) {
            return result;
        }
        IndexInput input = directory.openInput("deletable");
        try {
            for (int i = input.readInt(); i > 0; --i) {
                result.addElement(input.readString());
            }
        }
        finally {
            input.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeDeleteableFiles(Directory directory, List files) throws IOException {
        IndexOutput output = directory.createOutput("deleteable.new");
        try {
            output.writeInt(files.size());
            Iterator it = files.iterator();
            while (it.hasNext()) {
                output.writeString((String)it.next());
            }
        }
        finally {
            output.close();
        }
        directory.renameFile("deleteable.new", "deletable");
    }
}

