/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bandana.impl;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaPersister;
import com.atlassian.bandana.impl.PersisterKey;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import org.apache.log4j.Category;

public class CachingBandanaPersister
implements BandanaPersister {
    private static final Category log = Category.getInstance((Class)CachingBandanaPersister.class);
    BandanaPersister delegatedPersister;
    Cache cache;

    public CachingBandanaPersister(BandanaPersister delegatedPersister, Cache cache) {
        this.delegatedPersister = delegatedPersister;
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object retrieve(BandanaContext context, String key) {
        PersisterKey pKey = new PersisterKey(context, key);
        try {
            if (this.cache.get((Serializable)pKey) == null) {
                Cache cache = this.cache;
                synchronized (cache) {
                    Object value = this.delegatedPersister.retrieve(context, key);
                    this.cache.put(new Element((Serializable)pKey, (Serializable)value));
                }
            }
            return this.cache.get((Serializable)pKey).getValue();
        }
        catch (CacheException e) {
            log.error((Object)("Error retrieving cached object: " + (Object)((Object)e)), (Throwable)e);
            return null;
        }
    }

    public Map retrieve(BandanaContext context) {
        return this.delegatedPersister.retrieve(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(BandanaContext context, String key, Object value) {
        this.delegatedPersister.store(context, key, value);
        PersisterKey pKey = new PersisterKey(context, key);
        Cache cache = this.cache;
        synchronized (cache) {
            this.cache.put(new Element((Serializable)pKey, (Serializable)value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCaches() {
        Cache cache = this.cache;
        synchronized (cache) {
            try {
                this.cache.removeAll();
            }
            catch (CacheException e) {
                log.error((Object)("Error flushing cache: " + (Object)((Object)e)), (Throwable)e);
            }
        }
    }

    public void remove(BandanaContext context) {
        this.delegatedPersister.remove(context);
        try {
            Iterator iterator = this.cache.getKeys().iterator();
            while (iterator.hasNext()) {
                PersisterKey persisterKey = (PersisterKey)iterator.next();
                if (!persisterKey.getContext().equals(context)) continue;
                this.cache.remove((Serializable)persisterKey);
            }
        }
        catch (CacheException e) {
            throw new RuntimeException(e);
        }
    }

    public void remove(BandanaContext context, String key) {
        this.cache.remove((Serializable)new PersisterKey(context, key));
    }
}

