/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.queue;

import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.UnboundedFifoBuffer;
import org.apache.log4j.Category;

public class MailQueueImpl
implements MailQueue {
    private static final Category log = Category.getInstance((Class)MailQueueImpl.class);
    private Buffer items = BufferUtils.synchronizedBuffer((Buffer)new UnboundedFifoBuffer());
    private Buffer errorItems = BufferUtils.synchronizedBuffer((Buffer)new UnboundedFifoBuffer());
    private boolean sending;
    private MailQueueItem itemBeingSent;
    private Timestamp sendingStarted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBuffer() {
        if (this.sending) {
            log.warn((Object)("Already sending " + this.items.size() + " mails:"));
            Iterator iter = this.items.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                log.warn((Object)("Sending: " + o + ", " + o.getClass()));
            }
            return;
        }
        this.sendingStarted();
        ArrayList<MailQueueItem> failed = new ArrayList<MailQueueItem>();
        try {
            while (!this.items.isEmpty()) {
                MailQueueItem item;
                String origThreadName = Thread.currentThread().getName();
                this.itemBeingSent = item = (MailQueueItem)this.items.remove();
                log.debug((Object)("Sending: " + item));
                try {
                    Thread.currentThread().setName("Sending mailitem " + item);
                    item.send();
                }
                catch (MailException e) {
                    if (item.getSendCount() > 10) {
                        this.errorItems.add((Object)item);
                    } else {
                        failed.add(item);
                    }
                    log.error((Object)("Error occurred in sending e-mail: " + item), (Throwable)((Object)e));
                }
                finally {
                    Thread.currentThread().setName(origThreadName);
                }
            }
            this.items.addAll(failed);
        }
        finally {
            this.sendingStopped();
        }
    }

    public int size() {
        return this.items.size();
    }

    public int errorSize() {
        return this.errorItems.size();
    }

    public void addItem(MailQueueItem item) {
        log.debug((Object)("Queued: " + item));
        this.items.add((Object)item);
    }

    public void addErrorItem(MailQueueItem item) {
        log.debug((Object)("Queued error: " + item));
        this.errorItems.add((Object)item);
    }

    public Buffer getQueue() {
        return this.items;
    }

    public Buffer getErrorQueue() {
        return this.errorItems;
    }

    public boolean isSending() {
        return this.sending;
    }

    public Timestamp getSendingStarted() {
        return this.sendingStarted;
    }

    public MailQueueItem getItemBeingSent() {
        return this.itemBeingSent;
    }

    public void unstickQueue() {
        log.error((Object)("Mail on queue was considered stuck: " + this.itemBeingSent));
        this.sendingStopped();
    }

    public void emptyErrorQueue() {
        this.errorItems.clear();
    }

    public void resendErrorQueue() {
        this.items.addAll((Collection)this.errorItems);
        this.emptyErrorQueue();
    }

    public void sendingStarted() {
        this.sending = true;
        this.sendingStarted = new Timestamp(System.currentTimeMillis());
    }

    public void sendingStopped() {
        this.sending = false;
        this.sendingStarted = null;
    }
}

