/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.server.managers;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.core.user.preferences.DefaultPreferences;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.PopMailServer;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.mail.server.impl.PopMailServerImpl;
import com.atlassian.mail.server.impl.SMTPMailServerImpl;
import com.atlassian.mail.server.managers.AbstractMailServerManager;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilMisc;

public class OFBizMailServerManager
extends AbstractMailServerManager {
    public MailServer getMailServer(Long id) throws MailException {
        try {
            GenericValue gv = CoreFactory.getGenericDelegator().findByPrimaryKeyCache("MailServer", UtilMisc.toMap((String)"id", (Object)id));
            if (gv == null) {
                return null;
            }
            return this.constructMailServer(gv);
        }
        catch (GenericEntityException e) {
            throw new MailException(e);
        }
    }

    public MailServer getMailServer(String name) throws MailException {
        try {
            GenericValue gv = EntityUtil.getOnly((List)CoreFactory.getGenericDelegator().findByAndCache("MailServer", UtilMisc.toMap((String)"name", (Object)name)));
            if (gv == null) {
                return null;
            }
            return this.constructMailServer(gv);
        }
        catch (GenericEntityException e) {
            throw new MailException(e);
        }
    }

    public List getServerNames() throws MailException {
        try {
            List mailServerGVs = CoreFactory.getGenericDelegator().findAllCache("MailServer", UtilMisc.toList((Object)"id asc"));
            ArrayList<MailServer> mailServers = new ArrayList<MailServer>();
            for (int i = 0; i < mailServerGVs.size(); ++i) {
                GenericValue emailServerGV = (GenericValue)mailServerGVs.get(i);
                mailServers.add(this.constructMailServer(emailServerGV));
            }
            return mailServers;
        }
        catch (GenericEntityException e) {
            throw new MailException(e);
        }
    }

    public List getSmtpMailServers() throws MailException {
        return this.getMailServersByType(SERVER_TYPES[1]);
    }

    public List getPopMailServers() throws MailException {
        return this.getMailServersByType(SERVER_TYPES[0]);
    }

    public Long create(MailServer mailServer) throws MailException {
        try {
            GenericValue storedMailServer = EntityUtils.createValue((String)"MailServer", (Map)this.getMapFromColumns(mailServer));
            return storedMailServer.getLong("id");
        }
        catch (GenericEntityException e) {
            throw new MailException(e);
        }
    }

    public void update(MailServer mailServer) throws MailException {
        try {
            GenericValue storedMailServer = this.getMailServerGV(mailServer.getId());
            storedMailServer.setFields(this.getMapFromColumns(mailServer));
            storedMailServer.store();
        }
        catch (GenericEntityException e) {
            throw new MailException(e);
        }
    }

    public void delete(Long mailServerId) throws MailException {
        try {
            GenericValue storedMailServer = this.getMailServerGV(mailServerId);
            storedMailServer.remove();
        }
        catch (GenericEntityException e) {
            throw new MailException(e);
        }
    }

    public SMTPMailServer getDefaultSMTPMailServer() {
        SMTPMailServer smtps = null;
        try {
            DefaultPreferences dp = new DefaultPreferences();
            smtps = (SMTPMailServer)this.getMailServer(dp.getString("DefaultSmtpServer"));
            if (smtps != null) {
                return smtps;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.getSmtpMailServers() == null || this.getSmtpMailServers().size() == 0) {
                return null;
            }
            return (SMTPMailServer)this.getSmtpMailServers().get(0);
        }
        catch (MailException mailException) {
            return null;
        }
    }

    public PopMailServer getDefaultPopMailServer() {
        PopMailServer pops = null;
        try {
            DefaultPreferences dp = new DefaultPreferences();
            pops = (PopMailServer)this.getMailServer(dp.getString("DefaultPopServer"));
            if (pops != null) {
                return pops;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.getPopMailServers() == null || this.getPopMailServers().size() == 0) {
                return null;
            }
            return (PopMailServer)this.getPopMailServers().get(0);
        }
        catch (MailException mailException) {
            return null;
        }
    }

    protected List getMailServersByType(String serverType) throws MailException {
        ArrayList<MailServer> returnValue = new ArrayList<MailServer>();
        List mailServers = this.getServerNames();
        for (int i = 0; i < mailServers.size(); ++i) {
            MailServer mailServer = (MailServer)mailServers.get(i);
            if (!serverType.equals(mailServer.getType())) continue;
            returnValue.add(mailServer);
        }
        return returnValue;
    }

    protected GenericValue getMailServerGV(Long id) throws MailException {
        try {
            return CoreFactory.getGenericDelegator().findByPrimaryKeyCache("MailServer", UtilMisc.toMap((String)"id", (Object)id));
        }
        catch (GenericEntityException e) {
            throw new MailException(e);
        }
    }

    protected MailServer constructMailServer(GenericValue gv) {
        if (SERVER_TYPES[0].equals(gv.getString("type"))) {
            return new PopMailServerImpl(gv.getLong("id"), gv.getString("name"), gv.getString("description"), gv.getString("servername"), gv.getString("username"), gv.getString("password"));
        }
        if (SERVER_TYPES[1].equals(gv.getString("type"))) {
            String port = gv.getString("smtpPort");
            if (port == null) {
                port = "25";
            }
            if (TextUtils.stringSet((String)gv.getString("servername"))) {
                return new SMTPMailServerImpl(gv.getLong("id"), gv.getString("name"), gv.getString("description"), gv.getString("from"), gv.getString("prefix"), false, gv.getString("servername"), gv.getString("username"), gv.getString("password"), port);
            }
            return new SMTPMailServerImpl(gv.getLong("id"), gv.getString("name"), gv.getString("description"), gv.getString("from"), gv.getString("prefix"), true, gv.getString("jndilocation"), gv.getString("username"), gv.getString("password"), port);
        }
        return null;
    }

    protected Map getMapFromColumns(MailServer mailServer) throws MailException {
        HashMap<String, String> columns = new HashMap<String, String>();
        columns.put("name", mailServer.getName());
        columns.put("description", mailServer.getDescription());
        columns.put("username", mailServer.getUsername());
        columns.put("password", mailServer.getPassword());
        columns.put("type", mailServer.getType());
        columns.put("servername", mailServer.getHostname());
        if (!SERVER_TYPES[0].equals(mailServer.getType())) {
            if (SERVER_TYPES[1].equals(mailServer.getType())) {
                SMTPMailServer smtp = (SMTPMailServer)mailServer;
                columns.put("from", smtp.getDefaultFrom());
                columns.put("prefix", smtp.getPrefix());
                columns.put("smtpPort", smtp.getSmtpPort());
                if (smtp.isSessionServer()) {
                    columns.put("jndilocation", smtp.getJndiLocation());
                } else {
                    columns.put("servername", smtp.getHostname());
                }
            } else {
                throw new MailException("The Type of Mail Server is not recognised");
            }
        }
        return columns;
    }
}

