/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.compatibility.cache.spring;

import com.atlassian.cache.CacheManager;
import com.atlassian.user.impl.cache.Cache;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;

public class BucketAndAtlassianUserCacheManagerCompatibilityBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter {
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

    public PropertyValues postProcessPropertyValues(PropertyValues propertyValues, PropertyDescriptor[] propertyDescriptors, Object bean, String beanName) throws BeansException {
        MutablePropertyValues updatedPropertyValues = new MutablePropertyValues(propertyValues);
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            if (!this.isBucketCacheManagerOrAtlassianUserCacheManager(propertyDescriptors[i].getPropertyType())) continue;
            this.log.warn((Object)("Class <" + bean.getClass() + "> still uses the deprecated cache manager, " + "this should be changed to use the new interface " + CacheManager.class));
            PropertyValue propertyValue = this.getPropertyValue(propertyValues, propertyDescriptors[i]);
            if (propertyValue != null) {
                PropertyValue updatedPropertyValue = new PropertyValue(propertyValue.getName(), (Object)this.getCacheManagerAdapter((CacheManager)propertyValue.getValue()));
                updatedPropertyValues.addPropertyValue(updatedPropertyValue);
                continue;
            }
            this.log.error((Object)("Could not find property of type com.atlassian.cache.CacheManager to set to <" + propertyDescriptors[i].getName() + ">. Are you using autowiring by type?"));
        }
        return updatedPropertyValues;
    }

    private boolean isBucketCacheManagerOrAtlassianUserCacheManager(Class beanClass) {
        return beanClass != null && (beanClass.equals(com.atlassian.user.impl.cache.CacheManager.class) || beanClass.equals(bucket.cache.CacheManager.class));
    }

    private PropertyValue getPropertyValue(PropertyValues propertyValues, PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getName() != null ? propertyValues.getPropertyValue(propertyDescriptor.getName()) : null;
    }

    private com.atlassian.user.impl.cache.CacheManager getCacheManagerAdapter(CacheManager cacheManager) {
        return new CacheManagerAdapter(cacheManager);
    }

    private static class CacheAdapter
    implements Cache {
        private final com.atlassian.cache.Cache cache;

        public CacheAdapter(com.atlassian.cache.Cache cache) {
            this.cache = cache;
        }

        public String getName() {
            return this.cache.getName();
        }

        public Object get(Object o) {
            return this.cache.get(o);
        }

        public List getKeys() {
            return new ArrayList(this.cache.getKeys());
        }

        public void put(Object key, Object value) {
            this.cache.put(key, value);
        }

        public void remove(Object key) {
            this.cache.remove(key);
        }

        public void removeAll() {
            this.cache.removeAll();
        }

        public int getStatus() {
            return 0;
        }
    }

    private static class CacheManagerAdapter
    implements bucket.cache.CacheManager {
        private final CacheManager cacheManager;

        public CacheManagerAdapter(CacheManager cacheManager) {
            if (cacheManager == null) {
                throw new IllegalArgumentException("CacheManager must not be null");
            }
            this.cacheManager = cacheManager;
        }

        public Cache getCache(String s) {
            return new CacheAdapter(this.cacheManager.getCache(s));
        }

        public void flushCaches() {
            this.cacheManager.flushCaches();
        }

        public void setNonFlushableCaches(List list) {
        }
    }
}

