/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.tools;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.tools.view.context.ViewContext;
import org.apache.velocity.tools.view.tools.ViewTool;

public class CookieTool
implements ViewTool {
    protected HttpServletRequest request;
    protected HttpServletResponse response;

    public void init(Object obj) {
        ViewContext context = (ViewContext)obj;
        this.request = context.getRequest();
        this.response = context.getResponse();
    }

    public Cookie[] getAll() {
        return this.request.getCookies();
    }

    public Cookie get(String name) {
        Cookie[] all = this.getAll();
        if (all == null) {
            return null;
        }
        for (int i = 0; i < all.length; ++i) {
            Cookie cookie = all[i];
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    public void add(String name, String value) {
        this.response.addCookie(new Cookie(name, value));
    }

    public void add(String name, String value, int maxAge) {
        Cookie c = new Cookie(name, value);
        c.setMaxAge(maxAge);
        this.response.addCookie(c);
    }
}

