/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ldaptemplate.support.acegi;

import net.sf.ldaptemplate.AuthenticationSource;
import net.sf.ldaptemplate.support.acegi.LdapTemplateUser;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AcegiAuthenticationSource
implements AuthenticationSource {
    private static final Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sf.ldaptemplate.support.acegi.AcegiAuthenticationSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public String getPrincipal() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            Object principal = authentication.getPrincipal();
            if (!(principal instanceof LdapTemplateUser)) {
                throw new IllegalArgumentException("The principal property of the authentication object -needs to be a LdapTemplateUser.Are you using LdapTemplateLdapAuthenticationProvider as required?");
            }
            LdapTemplateUser details = (LdapTemplateUser)((Object)principal);
            return details.getDn();
        }
        log.warn((Object)"No Authentication object set in SecurityContext - returning empty String as Principal");
        return "";
    }

    public String getCredentials() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            return (String)authentication.getCredentials();
        }
        log.warn((Object)"No Authentication object set in SecurityContext - returning empty String as Credentials");
        return "";
    }
}

