/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.config;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.config.ResourceLoader;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JNDIConfigUtil {
    public static final String JNDI_CONFIG_XML_FILENAME = "jndiservers.xml";
    protected static Map jndiServerInfos = new HashMap();

    protected static Element getXmlRootElement() throws GenericConfigException {
        try {
            return ResourceLoader.getXmlRootElement(JNDI_CONFIG_XML_FILENAME);
        }
        catch (GenericConfigException e) {
            throw new GenericConfigException("Could not get JNDI XML root element", e);
        }
    }

    protected static Document getXmlDocument() throws GenericConfigException {
        try {
            return ResourceLoader.getXmlDocument(JNDI_CONFIG_XML_FILENAME);
        }
        catch (GenericConfigException e) {
            throw new GenericConfigException("Could not get JNDI XML document", e);
        }
    }

    public static void initialize(Element rootElement) throws GenericConfigException {
        List childElements = null;
        Iterator elementIter = null;
        childElements = UtilXml.childElementList(rootElement, "jndi-server");
        elementIter = childElements.iterator();
        while (elementIter.hasNext()) {
            Element curElement = (Element)elementIter.next();
            JndiServerInfo jndiServerInfo = new JndiServerInfo(curElement);
            jndiServerInfos.put(jndiServerInfo.name, jndiServerInfo);
        }
    }

    public static JndiServerInfo getJndiServerInfo(String name) {
        return (JndiServerInfo)jndiServerInfos.get(name);
    }

    static {
        try {
            JNDIConfigUtil.initialize(JNDIConfigUtil.getXmlRootElement());
        }
        catch (Exception e) {
            Debug.logError(e, "Error loading JNDI config XML file jndiservers.xml");
        }
    }

    public static class JndiServerInfo {
        public String name;
        public String contextProviderUrl;
        public String initialContextFactory;
        public String urlPkgPrefixes;
        public String securityPrincipal;
        public String securityCredentials;

        public JndiServerInfo(Element element) {
            this.name = element.getAttribute("name");
            this.contextProviderUrl = element.getAttribute("context-provider-url");
            this.initialContextFactory = element.getAttribute("initial-context-factory");
            this.urlPkgPrefixes = element.getAttribute("url-pkg-prefixes");
            this.securityPrincipal = element.getAttribute("security-principal");
            this.securityCredentials = element.getAttribute("security-credentials");
        }
    }
}

