/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.ofbiz.core.util.Debug;

public class CachedClassLoader
extends URLClassLoader {
    private String contextName;
    public static Map globalClassNameClassMap = new HashMap();
    public static HashSet globalBadClassNameSet = new HashSet();
    public Map localClassNameClassMap = new HashMap();
    public HashSet localBadClassNameSet = new HashSet();
    public static Map globalResourceMap = new HashMap();
    public static HashSet globalBadResourceNameSet = new HashSet();
    public Map localResourceMap = new HashMap();
    public HashSet localBadResourceNameSet = new HashSet();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$HashMap;

    public CachedClassLoader(ClassLoader parent, String contextName) {
        super(new URL[0], parent);
        this.contextName = contextName;
    }

    public String toString() {
        return "org.ofbiz.core.util.CachedClassLoader(" + this.contextName + ") / " + this.getParent().toString();
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> theClass = (Class<?>)globalClassNameClassMap.get(name);
        if (theClass == null) {
            theClass = (Class)this.localClassNameClassMap.get(name);
        }
        if (theClass == null && (this.localBadClassNameSet.contains(name) || globalBadClassNameSet.contains(name))) {
            if (Debug.verboseOn()) {
                Debug.logVerbose("Cached loader got a known bad class name: [" + name + "]");
            }
            throw new ClassNotFoundException("Cached loader got a known bad class name: " + name);
        }
        if (theClass == null) {
            if (Debug.verboseOn()) {
                Debug.logVerbose("Cached loader cache miss for class name: [" + name + "]");
            }
            CachedClassLoader cachedClassLoader = this;
            synchronized (cachedClassLoader) {
                theClass = (Class)this.localClassNameClassMap.get(name);
                if (theClass == null) {
                    try {
                        theClass = super.loadClass(name, resolve);
                        if (this.isGlobalPath(name)) {
                            globalClassNameClassMap.put(name, theClass);
                        } else {
                            this.localClassNameClassMap.put(name, theClass);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        if (Debug.verboseOn()) {
                            Debug.logVerbose("Remembering invalid class name: [" + name + "]");
                        }
                        if (this.isGlobalPath(name)) {
                            globalBadClassNameSet.add(name);
                        } else {
                            this.localBadClassNameSet.add(name);
                        }
                        throw e;
                    }
                }
            }
        }
        return theClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getResource(String name) {
        URL theResource = (URL)globalResourceMap.get(name);
        if (theResource == null) {
            theResource = (URL)this.localResourceMap.get(name);
        }
        if (theResource == null && (this.localBadResourceNameSet.contains(name) || globalBadResourceNameSet.contains(name))) {
            if (Debug.verboseOn()) {
                Debug.logVerbose("Cached loader got a known bad resource name: [" + name + "]");
            }
            return null;
        }
        if (theResource == null) {
            Debug.logInfo("Cached loader cache miss for resource name: [" + name + "]");
            CachedClassLoader cachedClassLoader = this;
            synchronized (cachedClassLoader) {
                theResource = (URL)this.localResourceMap.get(name);
                if (theResource == null) {
                    theResource = super.getResource(name);
                    if (theResource == null) {
                        Debug.logInfo("Remembering invalid resource name: [" + name + "]");
                        if (this.isGlobalPath(name)) {
                            globalBadResourceNameSet.add(name);
                        } else {
                            this.localBadResourceNameSet.add(name);
                        }
                    } else if (this.isGlobalPath(name)) {
                        globalResourceMap.put(name, theResource);
                    } else {
                        this.localResourceMap.put(name, theResource);
                    }
                }
            }
        }
        return theResource;
    }

    protected boolean isGlobalPath(String name) {
        if (name.startsWith("java.") || name.startsWith("java/") || name.startsWith("/java/")) {
            return true;
        }
        if (name.startsWith("javax.") || name.startsWith("javax/") || name.startsWith("/javax/")) {
            return true;
        }
        if (name.startsWith("sun.") || name.startsWith("sun/") || name.startsWith("/sun/")) {
            return true;
        }
        return name.startsWith("org.ofbiz.core.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        globalClassNameClassMap.put("Object", class$java$lang$Object == null ? (class$java$lang$Object = CachedClassLoader.class$("java.lang.Object")) : class$java$lang$Object);
        globalClassNameClassMap.put("java.lang.Object", class$java$lang$Object == null ? (class$java$lang$Object = CachedClassLoader.class$("java.lang.Object")) : class$java$lang$Object);
        globalClassNameClassMap.put("String", class$java$lang$String == null ? (class$java$lang$String = CachedClassLoader.class$("java.lang.String")) : class$java$lang$String);
        globalClassNameClassMap.put("java.lang.String", class$java$lang$String == null ? (class$java$lang$String = CachedClassLoader.class$("java.lang.String")) : class$java$lang$String);
        globalClassNameClassMap.put("Boolean", class$java$lang$Boolean == null ? (class$java$lang$Boolean = CachedClassLoader.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        globalClassNameClassMap.put("java.lang.Boolean", class$java$lang$Boolean == null ? (class$java$lang$Boolean = CachedClassLoader.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        globalClassNameClassMap.put("Double", class$java$lang$Double == null ? (class$java$lang$Double = CachedClassLoader.class$("java.lang.Double")) : class$java$lang$Double);
        globalClassNameClassMap.put("java.lang.Double", class$java$lang$Double == null ? (class$java$lang$Double = CachedClassLoader.class$("java.lang.Double")) : class$java$lang$Double);
        globalClassNameClassMap.put("Float", class$java$lang$Float == null ? (class$java$lang$Float = CachedClassLoader.class$("java.lang.Float")) : class$java$lang$Float);
        globalClassNameClassMap.put("java.lang.Float", class$java$lang$Float == null ? (class$java$lang$Float = CachedClassLoader.class$("java.lang.Float")) : class$java$lang$Float);
        globalClassNameClassMap.put("Long", class$java$lang$Long == null ? (class$java$lang$Long = CachedClassLoader.class$("java.lang.Long")) : class$java$lang$Long);
        globalClassNameClassMap.put("java.lang.Long", class$java$lang$Long == null ? (class$java$lang$Long = CachedClassLoader.class$("java.lang.Long")) : class$java$lang$Long);
        globalClassNameClassMap.put("Integer", class$java$lang$Integer == null ? (class$java$lang$Integer = CachedClassLoader.class$("java.lang.Integer")) : class$java$lang$Integer);
        globalClassNameClassMap.put("java.lang.Integer", class$java$lang$Integer == null ? (class$java$lang$Integer = CachedClassLoader.class$("java.lang.Integer")) : class$java$lang$Integer);
        globalClassNameClassMap.put("Timestamp", class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = CachedClassLoader.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
        globalClassNameClassMap.put("java.sql.Timestamp", class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = CachedClassLoader.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
        globalClassNameClassMap.put("Time", class$java$sql$Time == null ? (class$java$sql$Time = CachedClassLoader.class$("java.sql.Time")) : class$java$sql$Time);
        globalClassNameClassMap.put("java.sql.Time", class$java$sql$Time == null ? (class$java$sql$Time = CachedClassLoader.class$("java.sql.Time")) : class$java$sql$Time);
        globalClassNameClassMap.put("Date", class$java$sql$Date == null ? (class$java$sql$Date = CachedClassLoader.class$("java.sql.Date")) : class$java$sql$Date);
        globalClassNameClassMap.put("java.sql.Date", class$java$sql$Date == null ? (class$java$sql$Date = CachedClassLoader.class$("java.sql.Date")) : class$java$sql$Date);
        globalClassNameClassMap.put("Locale", class$java$util$Locale == null ? (class$java$util$Locale = CachedClassLoader.class$("java.util.Locale")) : class$java$util$Locale);
        globalClassNameClassMap.put("java.util.Locale", class$java$util$Locale == null ? (class$java$util$Locale = CachedClassLoader.class$("java.util.Locale")) : class$java$util$Locale);
        globalClassNameClassMap.put("java.util.Date", class$java$util$Date == null ? (class$java$util$Date = CachedClassLoader.class$("java.util.Date")) : class$java$util$Date);
        globalClassNameClassMap.put("Collection", class$java$util$Collection == null ? (class$java$util$Collection = CachedClassLoader.class$("java.util.Collection")) : class$java$util$Collection);
        globalClassNameClassMap.put("java.util.Collection", class$java$util$Collection == null ? (class$java$util$Collection = CachedClassLoader.class$("java.util.Collection")) : class$java$util$Collection);
        globalClassNameClassMap.put("List", class$java$util$List == null ? (class$java$util$List = CachedClassLoader.class$("java.util.List")) : class$java$util$List);
        globalClassNameClassMap.put("java.util.List", class$java$util$List == null ? (class$java$util$List = CachedClassLoader.class$("java.util.List")) : class$java$util$List);
        globalClassNameClassMap.put("Set", class$java$util$Set == null ? (class$java$util$Set = CachedClassLoader.class$("java.util.Set")) : class$java$util$Set);
        globalClassNameClassMap.put("java.util.Set", class$java$util$Set == null ? (class$java$util$Set = CachedClassLoader.class$("java.util.Set")) : class$java$util$Set);
        globalClassNameClassMap.put("Map", class$java$util$Map == null ? (class$java$util$Map = CachedClassLoader.class$("java.util.Map")) : class$java$util$Map);
        globalClassNameClassMap.put("java.util.Map", class$java$util$Map == null ? (class$java$util$Map = CachedClassLoader.class$("java.util.Map")) : class$java$util$Map);
        globalClassNameClassMap.put("HashMap", class$java$util$HashMap == null ? (class$java$util$HashMap = CachedClassLoader.class$("java.util.HashMap")) : class$java$util$HashMap);
        globalClassNameClassMap.put("java.util.HashMap", class$java$util$HashMap == null ? (class$java$util$HashMap = CachedClassLoader.class$("java.util.HashMap")) : class$java$util$HashMap);
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            globalClassNameClassMap.put("GenericValue", loader.loadClass("org.ofbiz.core.entity.GenericValue"));
            globalClassNameClassMap.put("org.ofbiz.core.entity.GenericValue", loader.loadClass("org.ofbiz.core.entity.GenericValue"));
            globalClassNameClassMap.put("GenericPK", loader.loadClass("org.ofbiz.core.entity.GenericPK"));
            globalClassNameClassMap.put("org.ofbiz.core.entity.GenericPK", loader.loadClass("org.ofbiz.core.entity.GenericPK"));
            globalClassNameClassMap.put("GenericEntity", loader.loadClass("org.ofbiz.core.entity.GenericEntity"));
            globalClassNameClassMap.put("org.ofbiz.core.entity.GenericEntity", loader.loadClass("org.ofbiz.core.entity.GenericEntity"));
        }
        catch (ClassNotFoundException e) {
            Debug.logError(e, "Could not pre-initialize dynamically loaded class: ");
        }
    }
}

