/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.ofbiz.core.util.FlexibleProperties;
import org.ofbiz.core.util.UtilProperties;
import org.ofbiz.core.util.UtilURL;

public final class Debug {
    public static final boolean useLog4J = true;
    public static final String noModuleModule = "NoModule";
    static DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
    public static final int ALWAYS = 0;
    public static final int VERBOSE = 1;
    public static final int TIMING = 2;
    public static final int INFO = 3;
    public static final int IMPORTANT = 4;
    public static final int WARNING = 5;
    public static final int ERROR = 6;
    public static final int FATAL = 7;
    public static final String[] levels = new String[]{"Always", "Verbose", "Timing", "Info", "Important", "Warning", "Error", "Fatal"};
    public static final String[] levelProps = new String[]{"", "print.verbose", "print.timing", "print.info", "print.important", "print.warning", "print.error", "print.fatal"};
    public static final Priority[] levelObjs = new Priority[]{Priority.INFO, Priority.DEBUG, Priority.DEBUG, Priority.INFO, Priority.INFO, Priority.WARN, Priority.ERROR, Priority.FATAL};
    protected static Map levelStringMap = new HashMap();
    protected static PrintStream printStream = System.out;
    protected static PrintWriter printWriter = new PrintWriter(printStream);
    protected static boolean[] levelOnCache = new boolean[8];
    protected static final boolean useLevelOnCache = true;
    static Category root;

    public static PrintStream getPrintStream() {
        return printStream;
    }

    public static void setPrintStream(PrintStream printStream) {
        Debug.printStream = printStream;
        printWriter = new PrintWriter(printStream);
    }

    public static PrintWriter getPrintWriter() {
        return printWriter;
    }

    public static Category getLogger(String module) {
        if (module != null && module.length() > 0) {
            return Category.getInstance((String)module);
        }
        return root;
    }

    public static Integer getLevelFromString(String levelName) {
        if (levelName == null) {
            return null;
        }
        return (Integer)levelStringMap.get(levelName.toLowerCase());
    }

    public static int getLevelFromStringWithDefault(String levelName) {
        Integer levelInt = Debug.getLevelFromString(levelName);
        if (levelInt == null) {
            return 3;
        }
        return levelInt;
    }

    public static void log(int level, Throwable t, String msg, String module) {
        Debug.log(level, t, msg, module, "org.ofbiz.core.util.Debug");
    }

    public static void log(int level, Throwable t, String msg, String module, String callingClass) {
        if (Debug.isOn(level)) {
            Category logger = Debug.getLogger(module);
            logger.log(callingClass, levelObjs[level], (Object)msg, t);
        }
    }

    public static boolean isOn(int level) {
        return levelOnCache[level];
    }

    public static void log(String msg) {
        Debug.log(0, null, msg, noModuleModule);
    }

    public static void log(String msg, String module) {
        Debug.log(0, null, msg, module);
    }

    public static void log(Throwable t) {
        Debug.log(0, t, null, noModuleModule);
    }

    public static void log(Throwable t, String msg) {
        Debug.log(0, t, msg, noModuleModule);
    }

    public static void log(Throwable t, String msg, String module) {
        Debug.log(0, t, msg, module);
    }

    public static boolean verboseOn() {
        return Debug.isOn(1);
    }

    public static void logVerbose(String msg) {
        Debug.log(1, null, msg, noModuleModule);
    }

    public static void logVerbose(String msg, String module) {
        Debug.log(1, null, msg, module);
    }

    public static void logVerbose(Throwable t) {
        Debug.log(1, t, null, noModuleModule);
    }

    public static void logVerbose(Throwable t, String msg) {
        Debug.log(1, t, msg, noModuleModule);
    }

    public static void logVerbose(Throwable t, String msg, String module) {
        Debug.log(1, t, msg, module);
    }

    public static boolean timingOn() {
        return Debug.isOn(2);
    }

    public static void logTiming(String msg) {
        Debug.log(2, null, msg, noModuleModule);
    }

    public static void logTiming(String msg, String module) {
        Debug.log(2, null, msg, module);
    }

    public static void logTiming(Throwable t) {
        Debug.log(2, t, null, noModuleModule);
    }

    public static void logTiming(Throwable t, String msg) {
        Debug.log(2, t, msg, noModuleModule);
    }

    public static void logTiming(Throwable t, String msg, String module) {
        Debug.log(2, t, msg, module);
    }

    public static boolean infoOn() {
        return Debug.isOn(3);
    }

    public static void logInfo(String msg) {
        Debug.log(3, null, msg, noModuleModule);
    }

    public static void logInfo(String msg, String module) {
        Debug.log(3, null, msg, module);
    }

    public static void logInfo(Throwable t) {
        Debug.log(3, t, null, noModuleModule);
    }

    public static void logInfo(Throwable t, String msg) {
        Debug.log(3, t, msg, noModuleModule);
    }

    public static void logInfo(Throwable t, String msg, String module) {
        Debug.log(3, t, msg, module);
    }

    public static boolean importantOn() {
        return Debug.isOn(4);
    }

    public static void logImportant(String msg) {
        Debug.log(4, null, msg, noModuleModule);
    }

    public static void logImportant(String msg, String module) {
        Debug.log(4, null, msg, module);
    }

    public static void logImportant(Throwable t) {
        Debug.log(4, t, null, noModuleModule);
    }

    public static void logImportant(Throwable t, String msg) {
        Debug.log(4, t, msg, noModuleModule);
    }

    public static void logImportant(Throwable t, String msg, String module) {
        Debug.log(4, t, msg, module);
    }

    public static boolean warningOn() {
        return Debug.isOn(5);
    }

    public static void logWarning(String msg) {
        Debug.log(5, null, msg, noModuleModule);
    }

    public static void logWarning(String msg, String module) {
        Debug.log(5, null, msg, module);
    }

    public static void logWarning(Throwable t) {
        Debug.log(5, t, null, noModuleModule);
    }

    public static void logWarning(Throwable t, String msg) {
        Debug.log(5, t, msg, noModuleModule);
    }

    public static void logWarning(Throwable t, String msg, String module) {
        Debug.log(5, t, msg, module);
    }

    public static boolean errorOn() {
        return Debug.isOn(6);
    }

    public static void logError(String msg) {
        Debug.log(6, null, msg, noModuleModule);
    }

    public static void logError(String msg, String module) {
        Debug.log(6, null, msg, module);
    }

    public static void logError(Throwable t) {
        Debug.log(6, t, null, noModuleModule);
    }

    public static void logError(Throwable t, String msg) {
        Debug.log(6, t, msg, noModuleModule);
    }

    public static void logError(Throwable t, String msg, String module) {
        Debug.log(6, t, msg, module);
    }

    public static boolean fatalOn() {
        return Debug.isOn(7);
    }

    public static void logFatal(String msg) {
        Debug.log(7, null, msg, noModuleModule);
    }

    public static void logFatal(String msg, String module) {
        Debug.log(7, null, msg, module);
    }

    public static void logFatal(Throwable t) {
        Debug.log(7, t, null, noModuleModule);
    }

    public static void logFatal(Throwable t, String msg) {
        Debug.log(7, t, msg, noModuleModule);
    }

    public static void logFatal(Throwable t, String msg, String module) {
        Debug.log(7, t, msg, module);
    }

    public static void set(int level, boolean on) {
        Debug.levelOnCache[level] = on;
    }

    static {
        levelStringMap.put("verbose", new Integer(1));
        levelStringMap.put("timing", new Integer(2));
        levelStringMap.put("info", new Integer(3));
        levelStringMap.put("important", new Integer(4));
        levelStringMap.put("warning", new Integer(5));
        levelStringMap.put("error", new Integer(6));
        levelStringMap.put("fatal", new Integer(7));
        levelStringMap.put("always", new Integer(0));
        PropertyConfigurator.configure((Properties)FlexibleProperties.makeFlexibleProperties(UtilURL.fromResource("debug")));
        int i = 0;
        while (i < 8) {
            Debug.levelOnCache[i] = i == 0 || UtilProperties.propertyValueEqualsIgnoreCase("debug", levelProps[i], "true");
            ++i;
        }
        root = Category.getRoot();
    }
}

