/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.ofbiz.core.util.Debug;

public class FlexibleProperties
extends Properties {
    private static final boolean truncateIfMissingDefault = false;
    private static final boolean doPropertyExpansionDefault = true;
    private URL url = null;
    private boolean doPropertyExpansion = true;
    private boolean truncateIfMissing = false;

    public FlexibleProperties() {
    }

    public FlexibleProperties(Properties properties) {
        super(properties);
    }

    public FlexibleProperties(URL url) {
        this.url = url;
        this.init();
    }

    public FlexibleProperties(URL url, Properties properties) {
        super(properties);
        this.url = url;
        this.init();
    }

    public static FlexibleProperties makeFlexibleProperties(Properties properties) {
        return new FlexibleProperties(properties);
    }

    public static FlexibleProperties makeFlexibleProperties(URL url) {
        return new FlexibleProperties(url);
    }

    public static FlexibleProperties makeFlexibleProperties(URL url, Properties properties) {
        return new FlexibleProperties(url, properties);
    }

    public static FlexibleProperties makeFlexibleProperties(String[] keysAndValues) {
        if (keysAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("FlexibleProperties(String[] keysAndValues) cannot accept an odd number of elements!");
        }
        Properties newProperties = new Properties();
        int i = 0;
        while (i < keysAndValues.length) {
            newProperties.setProperty(keysAndValues[i], keysAndValues[i + 1]);
            i += 2;
        }
        return new FlexibleProperties(newProperties);
    }

    private void init() {
        try {
            this.load();
        }
        catch (IOException e) {
            Debug.log(e);
        }
    }

    public boolean getDoPropertyExpansion() {
        return this.doPropertyExpansion;
    }

    public void setDoPropertyExpansion(boolean doPropertyExpansion) {
        this.doPropertyExpansion = doPropertyExpansion;
    }

    public boolean getTruncateIfMissing() {
        return this.truncateIfMissing;
    }

    public void setTruncateIfMissing(boolean truncateIfMissing) {
        this.truncateIfMissing = truncateIfMissing;
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL url) {
        this.url = url;
        this.init();
    }

    public Properties getDefaultProperties() {
        return this.defaults;
    }

    public void setDefaultProperties(Properties defaults) {
        this.defaults = new FlexibleProperties(defaults);
    }

    protected synchronized void load() throws IOException {
        if (this.url == null) {
            return;
        }
        InputStream in = null;
        try {
            in = this.url.openStream();
        }
        catch (Exception urlex) {
            Debug.log("[FlexibleProperties.load]: Couldn't find the URL: " + this.url);
            Debug.log(urlex);
        }
        if (in == null) {
            throw new IOException("Could not open resource URL " + this.url);
        }
        super.load(in);
        in.close();
        if (this.defaults instanceof FlexibleProperties) {
            ((FlexibleProperties)this.defaults).reload();
        }
        if (this.getDoPropertyExpansion()) {
            this.interpolateProperties();
        }
    }

    public synchronized void store(String header) throws IOException {
        super.store(this.url.openConnection().getOutputStream(), header);
    }

    public synchronized void reload() throws IOException {
        Debug.log("Reloading the resource: " + this.url);
        this.load();
    }

    public void interpolateProperties() {
        if (this.defaults != null && this.defaults instanceof FlexibleProperties) {
            ((FlexibleProperties)this.defaults).interpolateProperties();
        }
        FlexibleProperties.interpolateProperties(this, this.getTruncateIfMissing());
    }

    public static void interpolateProperties(Properties props) {
        FlexibleProperties.interpolateProperties(props, false);
    }

    public static void interpolateProperties(Properties props, boolean truncateIfMissing) {
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            String value = props.getProperty(key);
            key = FlexibleProperties.interpolate(key, props, truncateIfMissing);
            props.setProperty(key, FlexibleProperties.interpolate(value, props, truncateIfMissing));
        }
    }

    public static String interpolate(String value, Properties props) {
        return FlexibleProperties.interpolate(value, props, false);
    }

    public static String interpolate(String value, Properties props, boolean truncateIfMissing) {
        return FlexibleProperties.interpolate(value, props, truncateIfMissing, null);
    }

    public static String interpolate(String value, Properties props, boolean truncateIfMissing, ArrayList beenThere) {
        if (props == null || value == null) {
            return value;
        }
        if (beenThere == null) {
            beenThere = new ArrayList<String>();
        }
        int start = value.indexOf("${");
        while (start > -1) {
            int end = value.indexOf("}", start + 2);
            if (end > start + 2) {
                String keyToExpand = value.substring(start + 2, end);
                int nestedStart = keyToExpand.indexOf("${");
                while (nestedStart > -1) {
                    if ((end = value.indexOf("}", end + 1)) > -1) {
                        keyToExpand = value.substring(start + 2, end);
                        nestedStart = keyToExpand.indexOf("${", nestedStart + 2);
                        continue;
                    }
                    Debug.log("[FlexibleProperties.interpolate] Malformed value: [" + value + "] " + "contained unbalanced start \"${\" and end \"}\" characters");
                    return value;
                }
                if (keyToExpand.indexOf("${") > -1) {
                    ArrayList tempBeenThere = new ArrayList(beenThere);
                    beenThere.add(keyToExpand);
                    keyToExpand = FlexibleProperties.interpolate(keyToExpand, props, truncateIfMissing, beenThere);
                    beenThere = tempBeenThere;
                }
                if (beenThere.contains(keyToExpand)) {
                    beenThere.add(keyToExpand);
                    Debug.log("[FlexibleProperties.interpolate] Recursion loop detected:  Property:[" + beenThere.get(0) + "] " + "included property: [" + keyToExpand + "]");
                    Debug.log("[FlexibleProperties.interpolate] Recursion loop path:" + beenThere);
                    return value;
                }
                String expandValue = null;
                if (keyToExpand.startsWith("env.")) {
                    String envValue = System.getProperty(keyToExpand.substring(4));
                    if (envValue == null) {
                        Debug.log("[FlexibleProperties.interpolate] ERROR: Could not find environment variable named: " + keyToExpand.substring(4));
                    } else {
                        expandValue = envValue;
                    }
                } else {
                    expandValue = props.getProperty(keyToExpand);
                }
                if (expandValue != null) {
                    if (expandValue.indexOf("${") > -1) {
                        ArrayList tempBeenThere = new ArrayList(beenThere);
                        beenThere.add(keyToExpand);
                        expandValue = FlexibleProperties.interpolate(expandValue, props, truncateIfMissing, beenThere);
                        beenThere = tempBeenThere;
                    }
                    value = value.substring(0, start) + expandValue + value.substring(end + 1);
                    end = start + expandValue.length();
                } else if (truncateIfMissing) {
                    value = value.substring(0, start) + value.substring(end + 1);
                }
            } else {
                Debug.log("[FlexibleProperties.interpolate] Value [" + value + "] starts but does end variable");
                return value;
            }
            start = value.indexOf("${", end);
        }
        return value;
    }

    public Object clone() {
        FlexibleProperties c = (FlexibleProperties)super.clone();
        if (this.defaults != null && !this.equals(this.defaults)) {
            c.defaults = (FlexibleProperties)this.getDefaultProperties().clone();
        }
        return c;
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer();
        Set<Object> keySet = this.keySet();
        Iterator<Object> keys = keySet.iterator();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            String value = this.getProperty(key);
            retVal.append(key);
            retVal.append("=");
            retVal.append(value);
            retVal.append("\n");
        }
        return retVal.toString();
    }
}

