/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.util.Hashtable;
import javax.naming.InitialContext;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.config.JNDIConfigUtil;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilCache;
import org.ofbiz.core.util.UtilValidate;

public class JNDIContextFactory {
    static UtilCache contexts = new UtilCache("entity.JNDIContexts", 0L, 0L);
    static /* synthetic */ Class class$org$ofbiz$core$util$JNDIContextFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InitialContext getInitialContext(String jndiServerName) throws GenericConfigException {
        InitialContext ic = (InitialContext)contexts.get(jndiServerName);
        if (ic == null) {
            Class clazz = class$org$ofbiz$core$util$JNDIContextFactory == null ? (class$org$ofbiz$core$util$JNDIContextFactory = JNDIContextFactory.class$("org.ofbiz.core.util.JNDIContextFactory")) : class$org$ofbiz$core$util$JNDIContextFactory;
            synchronized (clazz) {
                ic = (InitialContext)contexts.get(jndiServerName);
                if (ic == null) {
                    JNDIConfigUtil.JndiServerInfo jndiServerInfo = JNDIConfigUtil.getJndiServerInfo(jndiServerName);
                    if (jndiServerInfo == null) {
                        throw new GenericConfigException("ERROR: no jndi-server definition was found with the name " + jndiServerName + " in jndiservers.xml");
                    }
                    try {
                        if (UtilValidate.isEmpty(jndiServerInfo.contextProviderUrl)) {
                            ic = new InitialContext();
                        } else {
                            Hashtable<String, String> h = new Hashtable<String, String>();
                            h.put("java.naming.factory.initial", jndiServerInfo.initialContextFactory);
                            h.put("java.naming.provider.url", jndiServerInfo.contextProviderUrl);
                            if (jndiServerInfo.urlPkgPrefixes != null && jndiServerInfo.urlPkgPrefixes.length() > 0) {
                                h.put("java.naming.factory.url.pkgs", jndiServerInfo.urlPkgPrefixes);
                            }
                            if (jndiServerInfo.securityPrincipal != null && jndiServerInfo.securityPrincipal.length() > 0) {
                                h.put("java.naming.security.principal", jndiServerInfo.securityPrincipal);
                            }
                            if (jndiServerInfo.securityCredentials != null && jndiServerInfo.securityCredentials.length() > 0) {
                                h.put("java.naming.security.credentials", jndiServerInfo.securityCredentials);
                            }
                            ic = new InitialContext(h);
                        }
                    }
                    catch (Exception e) {
                        String errorMsg = "Error getting JNDI initial context for server name " + jndiServerName;
                        Debug.logError(e, errorMsg);
                        throw new GenericConfigException(errorMsg, e);
                    }
                    if (ic != null) {
                        contexts.put(jndiServerName, ic);
                    }
                }
            }
        }
        return ic;
    }

    public static void clearInitialContext(String jndiServerName) {
        InitialContext ic = (InitialContext)contexts.get(jndiServerName);
        if (ic != null) {
            contexts.remove(jndiServerName);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

