/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import com.ibm.bsf.BSFDeclaredBean;
import com.ibm.bsf.BSFEngine;
import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.util.BSFEngineImpl;
import com.ibm.bsf.util.BSFFunctions;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;
import org.ofbiz.core.util.Debug;

public class OfbizJsBsfEngine
extends BSFEngineImpl {
    private Scriptable global;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(BSFManager mgr, String lang, Vector declaredBeans) throws BSFException {
        super.initialize(mgr, lang, declaredBeans);
        try {
            Context cx = Context.enter();
            this.global = cx.initStandardObjects((ScriptableObject)new ImporterTopLevel(cx));
            Scriptable bsf = Context.toObject((Object)new BSFFunctions(mgr, (BSFEngine)this), (Scriptable)this.global);
            this.global.put("bsf", this.global, (Object)bsf);
            int size = declaredBeans.size();
            int i = 0;
            while (i < size) {
                this.declareBean((BSFDeclaredBean)declaredBeans.elementAt(i));
                ++i;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object eval(String source, int lineNo, int columnNo, Object oscript) throws BSFException {
        if (Debug.verboseOn()) {
            Debug.logVerbose("Running javascript script " + source + " through OFBiz BSH engine");
        }
        String script = oscript.toString();
        Object retval = null;
        try {
            block5: {
                try {
                    Context cx = Context.enter();
                    cx.setOptimizationLevel(9);
                    retval = cx.evaluateString(this.global, script, source, lineNo, null);
                    if (!(retval instanceof NativeJavaObject)) break block5;
                    retval = ((NativeJavaObject)retval).unwrap();
                }
                catch (Throwable t) {
                    this.handleError(t);
                    Object var9_10 = null;
                    Context.exit();
                    return retval;
                }
            }
            Object var9_9 = null;
            Context.exit();
            return retval;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            Context.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object call(Object object, String method, Object[] args) throws BSFException {
        Object theReturnValue = null;
        try {
            block5: {
                try {
                    Context cx = Context.enter();
                    Object fun = this.global.get(method, this.global);
                    if (fun == Scriptable.NOT_FOUND) {
                        throw new JavaScriptException((Object)("function " + method + " not found."));
                    }
                    theReturnValue = ScriptRuntime.call((Context)cx, (Object)fun, (Object)this.global, (Object[])args, null);
                    if (!(theReturnValue instanceof Wrapper)) break block5;
                    theReturnValue = ((Wrapper)theReturnValue).unwrap();
                }
                catch (Throwable t) {
                    this.handleError(t);
                    Object var8_9 = null;
                    Context.exit();
                    return theReturnValue;
                }
            }
            Object var8_8 = null;
            Context.exit();
            return theReturnValue;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            Context.exit();
            throw throwable;
        }
    }

    public void declareBean(BSFDeclaredBean bean) throws BSFException {
        Scriptable wrapped = Context.toObject((Object)bean.bean, (Scriptable)this.global);
        this.global.put(bean.name, this.global, (Object)wrapped);
    }

    public void undeclareBean(BSFDeclaredBean bean) throws BSFException {
        this.global.delete(bean.name);
    }

    private void handleError(Throwable t) throws BSFException {
        if (t instanceof WrappedException) {
            t = (Throwable)((WrappedException)t).unwrap();
        }
        String message = null;
        Throwable target = t;
        if (t instanceof JavaScriptException) {
            message = t.getLocalizedMessage();
            Object value = ((JavaScriptException)t).getValue();
            if (value instanceof Throwable) {
                target = (Throwable)value;
            }
        } else if (t instanceof EvaluatorException || t instanceof SecurityException) {
            message = t.getLocalizedMessage();
        } else if (t instanceof RuntimeException) {
            message = "Internal Error: " + t.toString();
        } else if (t instanceof StackOverflowError) {
            message = "Stack Overflow";
        }
        if (message == null) {
            message = t.toString();
        }
        if (t instanceof Error && !(t instanceof StackOverflowError)) {
            throw (Error)t;
        }
        throw new BSFException(BSFException.REASON_OTHER_ERROR, "JavaScript Error: " + message, target);
    }
}

