/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import org.ofbiz.core.util.Debug;

public class UtilTimer {
    long realStartTime = this.startTime = System.currentTimeMillis();
    long startTime;
    long lastMessageTime = this.startTime;
    String lastMessage = "Begin";
    boolean log = false;

    public String timerString(String message) {
        return this.timerString(message, null);
    }

    public String timerString(String message, String module) {
        long tsStart = System.currentTimeMillis();
        String retString = "[[" + message + "- total:" + this.secondsSinceStart() + ",since last(" + (this.lastMessage.length() > 20 ? this.lastMessage.substring(0, 17) + "..." : this.lastMessage) + "):" + this.secondsSinceLast() + "]]";
        this.lastMessage = message;
        if (this.log) {
            Debug.log(2, null, retString, module, "org.ofbiz.core.util.UtilTimer");
        }
        this.lastMessageTime = System.currentTimeMillis();
        this.startTime += this.lastMessageTime - tsStart;
        return retString;
    }

    public double secondsSinceStart() {
        return (double)this.timeSinceStart() / 1000.0;
    }

    public double secondsSinceLast() {
        return (double)this.timeSinceLast() / 1000.0;
    }

    public long timeSinceStart() {
        long currentTime = System.currentTimeMillis();
        return currentTime - this.startTime;
    }

    public long timeSinceLast() {
        long currentTime = System.currentTimeMillis();
        return currentTime - this.lastMessageTime;
    }

    public void setLog(boolean log) {
        this.log = log;
    }

    public boolean getLog() {
        return this.log;
    }

    public String timerString(int level, String message) {
        StringBuffer retStringBuf = new StringBuffer();
        int i = 0;
        while (i < level) {
            retStringBuf.append("| ");
            ++i;
        }
        retStringBuf.append("(");
        String timeSinceStartStr = String.valueOf(this.timeSinceStart());
        retStringBuf.append(timeSinceStartStr + ",");
        String timeSinceLastStr = String.valueOf(this.timeSinceLast());
        retStringBuf.append(timeSinceLastStr);
        retStringBuf.append(")");
        int spacecount = 12 + 2 * level - retStringBuf.length();
        int i2 = 0;
        while (i2 < spacecount) {
            retStringBuf.append(' ');
            ++i2;
        }
        retStringBuf.append(message);
        this.lastMessageTime = System.currentTimeMillis();
        String retString = retStringBuf.toString();
        if (Debug.infoOn()) {
            Debug.logInfo(retString);
        }
        return retString;
    }
}

