/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.edit;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.PDResources;
import org.pdfbox.pdmodel.common.COSStreamArray;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.pdmodel.font.PDFont;
import org.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class PDPageContentStream {
    private PDPage page;
    private OutputStream output;
    private boolean inTextMode = false;
    private Map fontMappings = new HashMap();
    private Map imageMappings = new HashMap();
    private int fontNumber = 1;
    private int imageNumber = 1;
    private PDResources resources;
    private float[] colorComponents = new float[4];
    private NumberFormat formatDecimal = NumberFormat.getNumberInstance(Locale.US);
    private static final String BEGIN_TEXT = "BT\n";
    private static final String END_TEXT = "ET\n";
    private static final String SET_FONT = "Tf\n";
    private static final String MOVE_TEXT_POSITION = "Td\n";
    private static final String SHOW_TEXT = "Tj\n";
    private static final String SAVE_GRAPHICS_STATE = "q\n";
    private static final String RESTORE_GRAPHICS_STATE = "Q\n";
    private static final String CONCATENATE_MATRIX = "cm\n";
    private static final String XOBJECT_DO = "Do\n";
    private static final String RG_STROKING = "RG\n";
    private static final String RG_NON_STROKING = "rg\n";
    private static final String K_STROKING = "K\n";
    private static final String K_NON_STROKING = "k\n";
    private static final String G_STROKING = "G\n";
    private static final String G_NON_STROKING = "g\n";
    private static final String APPEND_RECTANGLE = "re\n";
    private static final String FILL = "f\n";
    private static final int SPACE = 32;

    public PDPageContentStream(PDDocument document, PDPage sourcePage) throws IOException {
        this(document, sourcePage, false, true);
    }

    public PDPageContentStream(PDDocument document, PDPage sourcePage, boolean appendContent, boolean compress) throws IOException {
        this.page = sourcePage;
        this.resources = this.page.getResources();
        if (this.resources == null) {
            this.resources = new PDResources();
            this.page.setResources(this.resources);
        }
        if (appendContent) {
            PDStream contents = sourcePage.getContents();
            PDStream contentsToAppend = new PDStream(document);
            COSStreamArray compoundStream = null;
            if (contents.getStream() instanceof COSStreamArray) {
                compoundStream = (COSStreamArray)contents.getStream();
                compoundStream.appendStream(contentsToAppend.getStream());
            } else {
                COSArray newArray = new COSArray();
                newArray.add(contents.getCOSObject());
                newArray.add(contentsToAppend.getCOSObject());
                compoundStream = new COSStreamArray(newArray);
            }
            if (compress) {
                ArrayList<COSName> filters = new ArrayList<COSName>();
                filters.add(COSName.FLATE_DECODE);
                contentsToAppend.setFilters(filters);
            }
            sourcePage.setContents(new PDStream(compoundStream));
            this.output = contentsToAppend.createOutputStream();
        } else {
            PDStream contents = new PDStream(document);
            if (compress) {
                ArrayList<COSName> filters = new ArrayList<COSName>();
                filters.add(COSName.FLATE_DECODE);
                contents.setFilters(filters);
            }
            sourcePage.setContents(contents);
            this.output = contents.createOutputStream();
        }
        this.formatDecimal.setMaximumFractionDigits(10);
        this.formatDecimal.setGroupingUsed(false);
    }

    public void beginText() throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: Nested beginText() calls are not allowed.");
        }
        this.appendRawCommands(BEGIN_TEXT);
        this.inTextMode = true;
    }

    public void endText() throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: You must call beginText() before calling endText.");
        }
        this.appendRawCommands(END_TEXT);
        this.inTextMode = false;
    }

    public void setFont(PDFont font, float fontSize) throws IOException {
        String fontMapping = (String)this.fontMappings.get(font);
        if (fontMapping == null) {
            fontMapping = "F" + this.fontNumber++;
            this.fontMappings.put(font, fontMapping);
            this.resources.getFonts().put(fontMapping, font);
        }
        this.appendRawCommands("/");
        this.appendRawCommands(fontMapping);
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(fontSize));
        this.appendRawCommands(32);
        this.appendRawCommands(SET_FONT);
    }

    public void drawImage(PDXObjectImage image, int x, int y) throws IOException {
        this.drawImage(image, x, y, image.getWidth(), image.getHeight());
    }

    public void drawImage(PDXObjectImage image, int x, int y, int width, int height) throws IOException {
        String imageMapping = (String)this.imageMappings.get(image);
        if (imageMapping == null) {
            imageMapping = "Im" + this.imageNumber++;
            this.imageMappings.put(image, imageMapping);
            this.resources.getImages().put(imageMapping, image);
        }
        this.appendRawCommands(SAVE_GRAPHICS_STATE);
        this.appendRawCommands(this.formatDecimal.format(width));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(0L));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(0L));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(height));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(x));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(CONCATENATE_MATRIX);
        this.appendRawCommands(32);
        this.appendRawCommands("/");
        this.appendRawCommands(imageMapping);
        this.appendRawCommands(32);
        this.appendRawCommands(XOBJECT_DO);
        this.appendRawCommands(32);
        this.appendRawCommands(RESTORE_GRAPHICS_STATE);
    }

    public void moveTextPositionByAmount(float x, float y) throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: must call beginText() before moveTextPositionByAmount");
        }
        this.appendRawCommands(this.formatDecimal.format(x));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(MOVE_TEXT_POSITION);
    }

    public void drawString(String text) throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: must call beginText() before drawString");
        }
        COSString string = new COSString(text);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        string.writePDF(buffer);
        this.appendRawCommands(new String(buffer.toByteArray(), "ISO-8859-1"));
        this.appendRawCommands(32);
        this.appendRawCommands(SHOW_TEXT);
    }

    public void setStrokingColor(Color color) throws IOException {
        ColorSpace colorSpace = color.getColorSpace();
        if (colorSpace.getType() == 5) {
            this.setStrokingColor(color.getRed(), color.getGreen(), color.getBlue());
        } else if (colorSpace.getType() == 6) {
            color.getColorComponents(this.colorComponents);
            this.setStrokingColor(this.colorComponents[0]);
        } else if (colorSpace.getType() == 9) {
            color.getColorComponents(this.colorComponents);
            this.setStrokingColor(this.colorComponents[0], this.colorComponents[2], this.colorComponents[2], this.colorComponents[3]);
        } else {
            throw new IOException("Error: unknown colorspace:" + colorSpace);
        }
    }

    public void setNonStrokingColor(Color color) throws IOException {
        ColorSpace colorSpace = color.getColorSpace();
        if (colorSpace.getType() == 5) {
            this.setNonStrokingColor(color.getRed(), color.getGreen(), color.getBlue());
        } else if (colorSpace.getType() == 6) {
            color.getColorComponents(this.colorComponents);
            this.setNonStrokingColor(this.colorComponents[0]);
        } else if (colorSpace.getType() == 9) {
            color.getColorComponents(this.colorComponents);
            this.setNonStrokingColor(this.colorComponents[0], this.colorComponents[2], this.colorComponents[2], this.colorComponents[3]);
        } else {
            throw new IOException("Error: unknown colorspace:" + colorSpace);
        }
    }

    public void setStrokingColor(int r, int g, int b) throws IOException {
        this.appendRawCommands(this.formatDecimal.format((double)r / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)g / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)b / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(RG_STROKING);
    }

    public void setStrokingColor(int c, int m, int y, int k) throws IOException {
        this.appendRawCommands(this.formatDecimal.format((double)c / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)m / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)y / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)k / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(K_STROKING);
    }

    public void setStrokingColor(double c, double m, double y, double k) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(c));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(m));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(k));
        this.appendRawCommands(32);
        this.appendRawCommands(K_STROKING);
    }

    public void setStrokingColor(int g) throws IOException {
        this.appendRawCommands(this.formatDecimal.format((double)g / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(G_STROKING);
    }

    public void setStrokingColor(double g) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(g));
        this.appendRawCommands(32);
        this.appendRawCommands(G_STROKING);
    }

    public void setNonStrokingColor(int r, int g, int b) throws IOException {
        this.appendRawCommands(this.formatDecimal.format((double)r / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)g / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)b / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(RG_NON_STROKING);
    }

    public void setNonStrokingColor(int c, int m, int y, int k) throws IOException {
        this.appendRawCommands(this.formatDecimal.format((double)c / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)m / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)y / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)k / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(K_NON_STROKING);
    }

    public void setNonStrokingColor(double c, double m, double y, double k) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(c));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(m));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(k));
        this.appendRawCommands(32);
        this.appendRawCommands(K_NON_STROKING);
    }

    public void setNonStrokingColor(int g) throws IOException {
        this.appendRawCommands(this.formatDecimal.format((double)g / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(G_NON_STROKING);
    }

    public void setNonStrokingColor(double g) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(g));
        this.appendRawCommands(32);
        this.appendRawCommands(G_NON_STROKING);
    }

    public void fillRect(float x, float y, float width, float height) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(x));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(width));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(height));
        this.appendRawCommands(32);
        this.appendRawCommands(APPEND_RECTANGLE);
        this.appendRawCommands(FILL);
    }

    public void appendRawCommands(String commands) throws IOException {
        this.appendRawCommands(commands.getBytes("ISO-8859-1"));
    }

    public void appendRawCommands(byte[] commands) throws IOException {
        this.output.write(commands);
    }

    public void appendRawCommands(int data) throws IOException {
        this.output.write(data);
    }

    public void close() throws IOException {
        this.output.close();
    }
}

