/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.interceptor;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.interceptor.TokenInterceptor;
import com.opensymphony.webwork.util.InvocationSessionStore;
import com.opensymphony.webwork.util.TokenHelper;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.Result;
import com.opensymphony.xwork.util.OgnlValueStack;
import javax.servlet.http.HttpServletRequest;

public class TokenSessionStoreInterceptor
extends TokenInterceptor {
    protected String handleInvalidToken(ActionInvocation invocation) throws Exception {
        ActionInvocation savedInvocation;
        HttpServletRequest request = ServletActionContext.getRequest();
        String tokenName = TokenHelper.getTokenName(request);
        String token = TokenHelper.getToken(tokenName, request);
        if (tokenName != null && token != null && (savedInvocation = InvocationSessionStore.loadInvocation(tokenName, token)) != null) {
            OgnlValueStack stack = savedInvocation.getStack();
            ServletActionContext.getRequest().setAttribute("webwork.valueStack", (Object)stack);
            Result result = savedInvocation.getResult();
            if (result != null && savedInvocation.getProxy().getExecuteResult()) {
                result.execute(savedInvocation);
            }
            invocation.getProxy().setExecuteResult(false);
            return savedInvocation.getResultCode();
        }
        return "invalid.token";
    }

    protected String handleValidToken(ActionInvocation invocation) throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        String key = TokenHelper.getTokenName(request);
        String token = TokenHelper.getToken(key, request);
        InvocationSessionStore.storeInvocation(key, token, invocation);
        return invocation.invoke();
    }
}

