AJS.toInit(function ($) {
    $("#type\\.TYPE_XML").change(xmlOutputChangeHandler);
    $("#type\\.TYPE_PDF").change(xmlOutputChangeHandler);
    $("#type\\.TYPE_HTML").change(xmlOutputChangeHandler);
    $("#contentOptionAll").change(contentOptionChangeHandler);
    $("#contentOptionVisible").change(contentOptionChangeHandler);
    $("#checkAllLink").click(function () {
        $(".exportContentTreeCheckbox").attr("checked", "checked");
        return false;
    });
    $("#clearAllLink").click(function () {
        $(".exportContentTreeCheckbox").attr("checked", "");
        return false;
    });
    
    function xmlOutputChangeHandler()
    {
        if ($("#type\\.TYPE_XML:checked").length) {
            $("#contentOptionAll").removeAttr("disabled");
        } else {
            // if they select a non-XML output option, renable content tree checkboxes (regardless of what state they were in) and disable the 'All content' option.
            $("#contentOptionAll").attr("disabled", "disabled");
            $("#contentOptionVisible").attr("checked", "checked");
            $(".exportContentTreeCheckbox").removeAttr("disabled");
        }
    }
    
    function contentOptionChangeHandler()
    {
        var isDisabled = !!$("#contentOptionAll:checked").length;
        $(".exportContentTreeCheckbox").each(function () {
            this.disabled = isDisabled;
        });
    }
});