// Requires prototype.js

// InputVerification Class  (Could be a little more abstract and used for other ajax form verification calls

var InputVerification = Class.create();
InputVerification.prototype = {

// initialize()
// Constructor runs on completion of the DOM loading.

    initialize: function(elementId, url)
    {
        this.url = url;
        this.elementId = elementId;
        Event.observe(elementId, 'blur', this.verify.bind(this), false);
    },

    verify: function()
    {
        var url = this.url;
        var param = this.elementId + "=" + $F(this.elementId);
        var myAjax = new Ajax.Request(url,
        {
            method: 'get',
            parameters: param,
            onComplete: this.update.bind(this)
        });
    },

    update: function(originalRequest)
    {
        var formElement = $(this.elementId);
        var boleanVal = originalRequest.responseXML.firstChild.getAttribute("result");
        if (boleanVal == "true")
        {
            this.removeErrorElement(formElement.parentNode)
        }
        else
        {
            if ($(this.elementId + "-error"))
            {
                this.removeErrorElement(formElement);
            }

            new Insertion.Before(formElement, "<div id='" + this.elementId + "-error' class='error'><span class='errorMessage'>" + originalRequest.responseXML.firstChild.firstChild.data + "</span></div>")
        }
    },

    removeErrorElement: function(element)
    {
        Element.remove($(this.elementId + "-error"));        
    }
}