AJS.Editor = {
    // Save the last edit mode in case the user changes to preview and from there to the other edit mode...
    // then we will have to convert the markup to XHTML or vice verca.
    lastEditMode: null,
    lastKnownGoodContent: null,
    contentHasChangedSinceLastAutoSave: false,

    syncTitleFieldWithForm: function() {
        var hiddenContentTitle = AJS.$("#hidden-content-title");
        if (hiddenContentTitle.length) {
            // Title field has been moved out of form to top of page,
            // copy the current field value into hidden field if value written.
            var title = "";

            var titleWrittenField = AJS.$("#titleWritten");
            if (!titleWrittenField.length || titleWrittenField.val() != "false") {
                // Creating a page - title may be "New Page" as placeholder, don't copy.
                title = AJS.$("#content-title").val();
            }

            hiddenContentTitle.val(title);
        }
    },

    // Save/Cancel fire unload, but draft shouldn't be saved.
    isSubmitting: false,

    saveDraft: function (async) {
        if (this.isSubmitting || !hasContentChanged())
            return;

        if (typeof async != "boolean") {
            async = true;
        }
        var form = getCurrentForm();
        var draftData = {};
        draftData.pageId = AJS.params.pageId;
        AJS.Editor.syncTitleFieldWithForm();
        if (form.title) {
            draftData.title = form.title.value;
        }
        if (form.newSpaceKey) {
            draftData.spaceKey = form.newSpaceKey.value;
        }
        else {
            draftData.spaceKey = escape(AJS.params.spaceKey);
        }
        if (form.originalVersion && form.originalVersion.value) {
            draftData.pageVersion = parseInt(form.originalVersion.value);
        }
        draftData.type = AJS.params.draftType;
        draftData.content = getCurrentFormContent(form);

        var draftStatus = jQuery("#draft-status");
        var resetWysiwygContent = AJS.params.useWysiwyg && inRichTextMode();

        var jsTime = function (date) { // dodgy time function
            var h = date.getHours();
            var m = date.getMinutes();
            var ampm = h > 11 ? "PM" : "AM";
            h = h % 12;
            return (h == 0 ? "12" : h) + ":" + (m < 10 ? "0" : "") + m + " " + ampm;
        };

        var resetContentChanged = function (response) {
            AJS.Editor.contentHasChangedSinceLastAutoSave = false;
            if (resetWysiwygContent) {
                editorResetContentChanged();
            }
            if (response.success)
            {
                var detail = {};
                try {
                    detail = eval("(" + response.response + ")");
                } catch (e) {
                    // ignore exception in eval
                }
                var time = detail["time"] || jsTime(new Date());
                draftStatus.removeClass("error");
                draftStatus.html(AJS.format(AJS.params.draftSavedMessage, time));
            } else {
                draftStatus.addClass("error");
                draftStatus.html(response.response);
            }
        };
        draftStatus.html(AJS.params.draftSavingMessage);
        DraftAjax.saveDraft(draftData, form.xhtml.value == "true", {
            callback: resetContentChanged,
            async: async,
            errorHandler: function () { resetContentChanged({ success: false, response: AJS.params.draftSavingTimedOutMessage }); },
            timeout: 30000 // 30 seconds
        });
    },

    /* This function will be invoked when the form gets submitted. */
    contentFormSubmit: function(e) {
        this.syncTitleFieldWithForm();

        AJS.$("#locationShowing").val("" + AJS.isVisible("#location_div"));
        AJS.$("#labelsShowing").val("" + AJS.isVisible("#labels_div"));

        // The permissions div may not appear if the user isn't able to assign permissions (e.g. anonymous)
        if(AJS.$("#permissionsDiv").css("display") == "block") {
            AJS.$("#restrictionsShowing").val("true");
        }

        this.isSubmitting = this.checkCaptchaResponse(e);
        return this.isSubmitting;
    },

    // Method checks whether the captchaResponse textfield is empty.
    checkCaptchaResponse: function(e) {
        if (e.target.name == "cancel") {
            return true;
        }

        var captchaTextField = AJS.$("#captchaResponse");

        if (captchaTextField.val() == "") {
            AJS.$("#captchaError").css("display", "block");
            window.scroll(0, 0);
            e.stopPropagation();
            return false;
        }
        return true;
    },

    heartbeat: function() {
        HeartbeatAjax.startActivity(AJS.params.pageId, AJS.params.draftType,
            function(activityResponses) {
                var otherUsersAreEditing = activityResponses.length > 0;
                if (otherUsersAreEditing) {
                    var edits = [];
                    for (var i = 0, len = activityResponses.length; i < len; ++i) {
                        var activityResponse = activityResponses[i];
                        var usernamelink = '<a href="' + AJS.params.contextPath + '/display/~' + activityResponse.userName + '">' + activityResponse.fullName + '</a>';
                        var lastEditDateMessage = '';
                        if (activityResponse.lastEditMessage != null) {
                            lastEditDateMessage = '<span class="smalltext"> ' + activityResponse.lastEditMessage + '</span>';
                        }
                        edits.push(usernamelink + lastEditDateMessage);
                    }
                    AJS.$("#other-users-span").html(edits.join(", "));
                }
                AJS.setVisible("#heartbeat-div", otherUsersAreEditing);
            }
        );
    },

    /* This function should be invoked when the preview frame has finished loading its content.
       It is responsible for updating the height of frame body to the actual content's height.
      */
    previewFrameOnload: function (body) {
        var $iframe = AJS.$("#previewArea iframe"),
            prevHeight = 0,
            counter = 0;

        //disable all forms, buttons and links in the iframe
        AJS.$("form", body).each(function() {
            AJS.$(this).unbind();
            this.onsubmit = function() {
                return false;
            };
        });
        AJS.$("a", body).each(function() {
            AJS.$(this).attr("target", "_top").unbind();
        });
        AJS.$("input", body).each(function() {
            AJS.$(this).unbind();
        });

        (function () {
            if (prevHeight < body.scrollHeight) {
                $iframe.height(Math.max(body.scrollHeight, $iframe.height()) + "px");
                prevHeight = body.scrollHeight;
                counter = 0;
            } else {
                counter++;
            }
            // uppper limit check for content height changes  
            if (counter < 500) {
                setTimeout(arguments.callee, 500);
            }
        })();
    }
};

function blankParent()
{
    var parentTextBox = AJS.$("#parentPageString");

    if(AJS.params.spaceKey != AJS.$("#newSpaceKey").val()) {
        parentTextBox.val("");
    } else {
        parentTextBox.val(AJS.params.originalParentPage);
    }
}

function publishFormData(formField, containerDiv, contentDiv)
{
    var formFieldValue = "";
    if (formField[0].type == "select-one") {
        formFieldValue = formField[0].options[formField[0].selectedIndex].text;
    } else {
	    formFieldValue = formField.val();
	}

    if (formField.val() != "") {
        contentDiv.html(formFieldValue);
        containerDiv.css("display", "");
    } else {
        containerDiv.css("display", "none");
    }
}

// this function is needed to store the caret position for IE browsers
// you need to insert a call to storeCaret(this); to the onclick, onselect and onkeyup events of
// the textarea you are editing
function storeCaret(textAreaObject) {
//    if (textAreaObject.createTextRange) {
//         // test for IE browsers
//        textAreaObject.caretPos = document.selection.createRange().duplicate();
//    }
}

// this function stores the selected and unselected text for the textarea in hidden fields on the form
function storeTextareaBits() {
    var t = AJS.$("#markupTextarea")[0];
    var currentForm = getCurrentForm();

    if (t.selectionStart != null) {
        // for netscape, mozilla, gecko
        t.sel = t.value.substr(t.selectionStart, t.selectionEnd - t.selectionStart);
        t.sel1 = t.value.substr(0, t.selectionStart);
        t.sel2 = t.value.substr(t.selectionEnd);
        currentForm.selectedText.value = t.sel;
    }
    else {
        if (document.selection && document.selection.createRange) {
            // for ie
            var str = document.selection.createRange().text;
            try {
                currentForm.elements[AJS.params.parametersName].focus();
            }
            catch (e) {
            // ignore
            }
            var sel = document.selection.createRange();
            currentForm.selectedText.value = sel.text;
        }
    }
}

function showRichText(show) {
    if (AJS.params.useWysiwyg) {
        if (show) {
            AJS.$("#wysiwyg").removeClass("hidden");
            AJS.$("#wysiwygTab").addClass("current");
            onShowEditor();
            // now we are in rich text mode, and may change the content, so any value in lastKnownGoodContent is obsolete
            AJS.Editor.lastKnownGoodContent = null;
        } else {
            onHideEditor();
            AJS.$("#wysiwyg").addClass("hidden");
            AJS.$("#wysiwygTab").removeClass("current");
        }
    }
}

function showMarkup(show) {
    var form = getCurrentForm(),
        fname1 = (show ? "removeClass" : "addClass"),
        fname2 = (show ? "addClass" : "removeClass");
    AJS.$("#markup")[fname1]("hidden");
    AJS.$("#markupTab")[fname2]("current");
    AJS.$(form)[fname2]("markup");
    AJS.$("#sidebar")[fname1]("hidden");
    AJS.$("#linkinserters")[fname1]("hidden");
}

function showPreview(show) {
    var fname1 = (show ? "removeClass" : "addClass"),
        fname2 = (show ? "addClass" : "removeClass");
    AJS.$("#preview")[fname1]("hidden");
    AJS.$("#previewTab")[fname2]("current");
}

function setRichTextDefault(value) {
    AjaxUserProfileEditor.setPreferenceUserEditWysiwyg(value);
    AJS.$("#makeRichTextDefault").addClass("hidden");
    AJS.$("#makeMarkupDefault").addClass("hidden");
}

function showWaitImage(flag) {
    AJS.$("#wysiwygWaitImage").css("visibility", (flag ? "visible" : "hidden"));
}

function reply_setTextArea(s) {
    showWaitImage(false);
    setMode(AJS.params.actionMarkup);
    if (s != null) {
        AJS.$("#markupTextarea").val(s);
    }
}

function reply_setEditorValue(s) {
    showWaitImage(false);
    setMode(AJS.params.actionRichtext);
    setEditorValue(s);
}

function reply_setPreviewArea(html) {
    showWaitImage(false);
    setMode(AJS.params.actionPreview);
    AJS.$("#previewArea").html('<iframe src="about:blank" scrolling="no"></iframe>');
    var iframe = AJS.$("#previewArea iframe")[0];
    var doc = iframe.contentDocument || iframe.contentWindow.document;
    doc.write(html);
    doc.close(); // for firefox
}

/**
* Set up the page for rich text or markup editing
*/
function setMode(mode) {
    var wasRichText = inRichTextMode();
    var form = getCurrentForm();

    if (mode != AJS.params.actionPreview) {
        form.xhtml.value = (mode == AJS.params.actionRichtext);
    }

    if (AJS.params.remoteUser && AJS.params.useWysiwyg) {
        AjaxUserProfileEditor.getPreferenceUserEditWysiwyg(showDefaultLinks);
    }

    // DON'T CHANGE THE ORDERING OF SHOWS
    // FIREFOX RENDERING GLITCHES WHEN PAGE LOADS TOO QUICKLY (if showMarkup() isn't first)
    if (mode == AJS.params.actionRichtext) {
        showMarkup(false);
        showRichText(true);
        showPreview(false);
    }
    else if (mode == AJS.params.actionMarkup) {
        showMarkup(true);
        showRichText(false);
        showPreview(false);
    }
    else if (mode == AJS.params.actionPreview) {
        if (AJS.params.saveDrafts) {
            AJS.Editor.saveDraft();
        }
        if (wasRichText) {
            // get the editor content in case we come back to wiki-markup
            AJS.Editor.lastKnownGoodContent = getEditorHTML() + "";
        }
        showPreview(true);
        showRichText(false);
        showMarkup(false);
    }

    form.mode.value = mode;
}

// Hide and show the "make default" links, based on what mode the user is currently in, and what the WYSIWYG setting is
function showDefaultLinks(defaultIsWysiwyg) {
    var showRichTextDefault = false;
    var showMarkupDefault = false;
    var form = getCurrentForm();

    // If we are in MARKUP mode, show the text to set markup as default
    if (defaultIsWysiwyg && form.mode.value == AJS.params.actionMarkup)
    {
        showMarkupDefault = true;
    }
    // If we are in RICHTEXT mode, show the text to set richtext as default
    else if (!defaultIsWysiwyg && form.mode.value == AJS.params.actionRichtext)
    {
        showRichTextDefault = true;
    }

    AJS.$("#makeRichTextDefault")[showRichTextDefault?"removeClass":"addClass"]("hidden");
    AJS.$("#makeMarkupDefault")[showMarkupDefault?"removeClass":"addClass"]("hidden");
}

function changeMode(newMode) {

    //## allowModeChange() only exists when WYSIWYG is enabled, so don't do a check otherwise (CONF-4935)
    // if the editor is in a state where the mode chnage will break things (e.g. not yet fully initialised)
    // don't allow the change
    if (AJS.params.useWysiwyg && inRichTextMode() && !allowModeChange()) {
        return false;
    }

    var oldMode = getCurrentForm().mode.value;
    if (oldMode == newMode) {
        return false;
    }

    showWaitImage(true);

    var contentId = AJS.params.contentId;
    if(!contentId || contentId == "")
        contentId = "0";

    if (newMode == AJS.params.actionMarkup) {
        if (oldMode == AJS.params.actionPreview) {
            if (AJS.Editor.lastEditMode == AJS.params.actionMarkup) { // Markup -> Preview -> Markup (no conversion)
                reply_setTextArea(null);
            }
            else { // WYSIWYG -> Preview -> Markup (convert HTML to wiki markup)
                WysiwygConverter.convertXHtmlToWikiMarkupWithoutPage(AJS.Editor.lastKnownGoodContent, contentId, reply_setTextArea);
            }
        }
        else { // WYSIWYG -> Markup, so just convert
            WysiwygConverter.convertXHtmlToWikiMarkupWithoutPage(getEditorHTML() + "", contentId, reply_setTextArea);
        }
    }
    else if (newMode == AJS.params.actionRichtext) {
        // If the current mode is preview...
        if (oldMode == AJS.params.actionPreview && AJS.Editor.lastEditMode == AJS.params.actionRichtext) {
            // WYSIWYG -> Preview -> WYSIWYG
            // We don't need to reload or convert the contents of the tinyMCE editor
            reply_setEditorValue(null);
        } else {
            // Markup -> Preview -> WYSIWYG
            // Convert the markup to be used with WYSIWYG
            // Markup -> WYSIWYG, so just grab the contents of the markup textarea and convert it to be used with WYSIWYG
            WysiwygConverter.convertWikiMarkupToXHtmlWithoutPage(AJS.$("#markupTextarea").val(), contentId, reply_setEditorValue);
        }
    }
    else { // Preview
        var queryParams = { "contentId": contentId,
                            "contentType": AJS.params.contentType,
                            "spaceKey": AJS.params.spaceKey };

        if (oldMode == AJS.params.actionRichtext) { // WYSIWYG -> Preview
            AJS.Editor.lastEditMode = AJS.params.actionRichtext;
            AJS.Editor.lastKnownGoodContent = queryParams.xHtml = getEditorHTML() + "";
        }
        else { // Markup -> Preview
            AJS.Editor.lastEditMode = AJS.params.actionMarkup;
            queryParams.wikiMarkup = AJS.$("#markupTextarea").val();
        }

        AJS.$.post(AJS.params.contextPath + "/pages/rendercontent.action", queryParams, reply_setPreviewArea);
    }

    return false;
}

function getCurrentForm() {
    return document.forms[AJS.params.formName];
}

// Fallback function for Safari to show to submit the form via JavaScript and display the preview page.
function sendFormWithPreview() {
    var form = getCurrentForm();
    // create a hidden field for the update variable
    var el = document.createElement("input");
    el.type = "hidden";
    el.name = "preview";
    el.name = "preview";
    el.value = "preview";
    form.appendChild(el);
    form.submit();
}

// function to send the form to discard/use the draft
function sendFormDraft(flagName) {
    var form = getCurrentForm();

    addHiddenElement(form, flagName, "true");
    addHiddenElement(form, "pageId", AJS.params.pageId);
    if (!form.spaceKey) {
        addHiddenElement(form, "spaceKey", AJS.params.spaceKey);
    }

    if (AJS.params.newPage) {
        form.action = "create" + AJS.params.draftType + ".action";
    } else {
        form.action = "edit" + AJS.params.draftType + ".action";
    }
    form.submit();
}

function addHiddenElement(form, name, value) {
    var el = document.createElement("input");
    el.type = "hidden";
    el.name = name;
    el.value = value;
    form.appendChild(el);
}

function inRichTextMode() {
    return getCurrentForm().mode.value == AJS.params.actionRichtext;
}

function hasContentChanged() {
    return AJS.Editor.contentHasChangedSinceLastAutoSave || (AJS.params.useWysiwyg && (inRichTextMode() && editorHasContentChanged()));
}

function contentChangeHandler() {
    AJS.Editor.contentHasChangedSinceLastAutoSave = true;
}

AJS.toInit(function ($) {

    $("#wysiwygTab a:first").click(function (e) {
        changeMode(AJS.params.actionRichtext);
        e.preventDefault();
        return false;
    });
    
    $("#markupTab a:first").click(function (e) {
        changeMode(AJS.params.actionMarkup);
        e.preventDefault();
        return false;
    });

    $("#previewTab a:first").click(function (e) {
        changeMode(AJS.params.actionPreview);
        e.preventDefault();
        return false;
    });

    $("#makeRichTextDefault").click(function (e) {
        setRichTextDefault(true);
        e.preventDefault();
        return false;
    });

    $("#makeMarkupDefault").click(function (e) {
        setRichTextDefault(false);
        e.preventDefault();
        return false;
    });
    
    $("#linkinserters a:first").click(function (e) {
        storeTextareaBits();
        var width = (3 * AJS.params.maxThumbWidth) + 100;
        window.open(this.href, "link_image_inserter", "width=" + width + ", height=400, resizable, scrollbars=yes");
        e.preventDefault();
        return false;
    });

    $("#linkinserters a:nth-child(2)").click(function (e) {
        storeTextareaBits();
        var selectedText = $("#selectedText").val();
        var popupUrl = this.href + (selectedText ? "&alias=" + selectedText : "");
        window.open(popupUrl,"link_inserter", "width=620, height=480, resizable, scrollbars=yes");
        e.preventDefault();
        try {
            AJS.Editor.LinkPopup = {};
        } catch(error) {
            AJS.log(error);
        }
        return false;
    });

    $("#markupTextarea").click(function () {
        storeCaret(this);
    }).select(function () {
        storeCaret(this);
        storeTextareaBits();
    }).keyup(function () {
        storeCaret(this);
        contentChangeHandler();
    }).change(function () {
        contentChangeHandler();
    });

    $(".submit-buttons").click(function (e) {
        AJS.Editor.contentFormSubmit(e);
    });

    $(".editor-template-link").click(function (e) {
        var form = AJS.$("#createpageform")[0];
        form.action = "createpage-choosetemplate.action";
        AJS.Editor.contentFormSubmit(e);
        form.submit();
    });

    if (AJS.params.useWysiwyg) {
        var errorHandler = function(message) {
            showWaitImage(false);
            // Ignore DWR errors because they almost always occur when users
            // click a link or submit during draft/heartbeat transmission.
            // Displaying a message when this occurs is just annoying.
        };
        // Initialisation
        DWREngine.setErrorHandler(errorHandler);
        DWREngine.setWarningHandler(errorHandler);
        // We should note here that the content has NOT finished loading
        editorOnLoad();
        
        $("#wysiwygTextarea").addClass("hidden");
        var timer = setInterval(function () {
            if (typeof tinyMCE != "undefined") {
                clearInterval(timer);
                setMode(AJS.params.editorMode);
            }
        }, 1);
    }

    if (AJS.params.saveDrafts) {
        $(window).unload(function () {
            AJS.Editor.saveDraft(false);
        });
        DraftAjax.getDraftSaveInterval(function (interval) {
                setInterval(AJS.Editor.saveDraft, interval);
            }
        );
    }

    if (AJS.params.heartbeat && AJS.params.pageId != "0") {
        AJS.Editor.heartbeat();
        HeartbeatAjax.getHeartbeatInterval(
            function (interval) { setInterval(AJS.Editor.heartbeat, interval); }
        );
    }

    // Move title field to place of title text
    var titleText = $("#title-text");
    var titleField = $("#content-title");
    if (titleText.length && titleField.length) { //only true for edit page screen in default theme
        var div = document.createElement("div");
        $(div).addClass("editable-title");
        $(div).append(titleField);
        if (!$.browser.msie) { // IE can't use full width due to CSS bugs
            $(window).load(function () { // wait until images are loaded
                jQuery(div).css("marginLeft", jQuery("img.logo").width() + 10 + "px"); // adjust for custom logos
            });
        }
        titleText.replaceWith(div);

        // Hidden field title will exist for pages created from links.
        var hiddenFields = $("#hidden-content-title");
        if (!hiddenFields.length) {
            var hiddenField = document.createElement("input");
            hiddenField.id = "hidden-content-title";
            hiddenField.type = "hidden";
            hiddenField.name = "title";
            hiddenField = $(hiddenField);

            var titleWrittenField = $("#titleWritten");
            if (!titleWrittenField.length || titleWrittenField.val() != "false") {
                hiddenField.val(titleField.val());
            }

            var editorDiv = $("#wiki-editor");
            editorDiv.before(hiddenField);
        }
    }
});

