/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.asm;

import org.aspectj.org.objectweb.asm.AnnotationVisitor;
import org.aspectj.org.objectweb.asm.Type;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.AnnotationAnnotationValue;
import org.aspectj.weaver.AnnotationNameValuePair;
import org.aspectj.weaver.AnnotationValue;
import org.aspectj.weaver.ArrayAnnotationValue;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ClassAnnotationValue;
import org.aspectj.weaver.EnumAnnotationValue;
import org.aspectj.weaver.SimpleAnnotationValue;
import org.aspectj.weaver.asm.ArrayAnnotationVisitor;

class AnnVisitor
implements AnnotationVisitor {
    private AnnotationAJ a;

    public AnnVisitor(AnnotationAJ annotationToPopulate) {
        this.a = annotationToPopulate;
    }

    public void visitEnum(String name, String type, String value) {
        EnumAnnotationValue val = new EnumAnnotationValue(type, value);
        this.a.addNameValuePair(new AnnotationNameValuePair(name, val));
    }

    public void visit(String name, Object value) {
        AnnotationValue val = null;
        if (value instanceof Integer) {
            val = new SimpleAnnotationValue(73, value);
        }
        if (value instanceof Boolean) {
            val = new SimpleAnnotationValue(90, value);
        }
        if (value instanceof Long) {
            val = new SimpleAnnotationValue(74, value);
        }
        if (value instanceof Short) {
            val = new SimpleAnnotationValue(83, value);
        }
        if (value instanceof Double) {
            val = new SimpleAnnotationValue(68, value);
        }
        if (value instanceof Float) {
            val = new SimpleAnnotationValue(70, value);
        }
        if (value instanceof Character) {
            val = new SimpleAnnotationValue(67, value);
        }
        if (value instanceof Byte) {
            val = new SimpleAnnotationValue(66, value);
        }
        if (value instanceof String) {
            val = new SimpleAnnotationValue(115, value);
        }
        if (val == null && value instanceof Type) {
            String classSignature = ((Type)value).getDescriptor();
            val = new ClassAnnotationValue(classSignature);
        }
        if (val == null) {
            throw new BCException("Annotation visitor choked on " + name + " = " + value);
        }
        this.a.addNameValuePair(new AnnotationNameValuePair(name, val));
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        AnnotationAJ annotation = new AnnotationAJ(desc, this.a.isRuntimeVisible());
        AnnotationAnnotationValue val = new AnnotationAnnotationValue(annotation);
        this.a.addNameValuePair(new AnnotationNameValuePair(name, val));
        return new AnnVisitor(annotation);
    }

    public AnnotationVisitor visitArray(String name) {
        ArrayAnnotationValue val = new ArrayAnnotationValue();
        this.a.addNameValuePair(new AnnotationNameValuePair(name, val));
        return new ArrayAnnotationVisitor(val, this.a.isRuntimeVisible());
    }

    public void visitEnd() {
    }
}

