/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.asm;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.GenericSignatureParser;
import org.aspectj.apache.bcel.classfile.Signature;
import org.aspectj.org.objectweb.asm.Attribute;
import org.aspectj.org.objectweb.asm.ClassReader;
import org.aspectj.org.objectweb.asm.ClassVisitor;
import org.aspectj.weaver.AbstractReferenceTypeDelegate;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.AnnotationTargetKind;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ReferenceTypeDelegate;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.SourceContextImpl;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.World;
import org.aspectj.weaver.asm.AjASMAttribute;
import org.aspectj.weaver.asm.AsmConstants;
import org.aspectj.weaver.asm.TypeVisitor;
import org.aspectj.weaver.bcel.BcelGenericSignatureToTypeXConverter;
import org.aspectj.weaver.patterns.PerClause;

public class AsmDelegate
extends AbstractReferenceTypeDelegate {
    public static boolean careAboutMemberAnnotationsAndAttributes = true;
    private World w;
    int classModifiers;
    ResolvedPointcutDefinition[] pointcuts = null;
    TypeVariable[] typeVariables;
    ResolvedType[] annotationTypes;
    AnnotationX[] annotationXs;
    List annotations = Collections.EMPTY_LIST;
    ResolvedMember[] methods;
    ResolvedMember[] fields;
    List attributes = Collections.EMPTY_LIST;
    Collection declares = null;
    Collection typeMungers = null;
    Collection privilegedAccesses = null;
    private int bitflag = 0;
    private static final int DISCOVERED_POINTCUTS = 1;
    private static final int DISCOVERED_DECLARES = 2;
    private static final int DISCOVERED_TYPEMUNGERS = 4;
    private static final int DISCOVERED_PRIVILEGEDACCESSES = 8;
    private static final int DISCOVERED_SOURCECONTEXT = 16;
    private static final int DISCOVERED_WEAVERSTATEINFO = 32;
    private static final int SIGNATURE_UNPACKED = 64;
    private static final int ANNOTATION_TYPES_CORRECT = 128;
    private static final int ANNOTATIONX_CORRECT = 256;
    private static final int SUPERSET = 512;
    private static final int FIELDSFIXEDUP = 1024;
    private static final int METHODSFIXEDUP = 2048;
    private ResolvedType superclassType = null;
    String superclassName = null;
    private ResolvedType[] interfaceTypes = null;
    String[] interfaceNames = null;
    boolean isAspect = false;
    PerClause perClause = null;
    AjAttribute.WeaverVersionInfo weaverVersion = AjAttribute.WeaverVersionInfo.UNKNOWN;
    WeaverStateInfo weaverStateInfo = null;
    boolean isAnonymous = false;
    boolean isNested = false;
    boolean isGenericType = false;
    String declaredSignature = null;
    boolean isRuntimeRetention = false;
    String retentionPolicy = null;
    boolean canAnnotationTargetType = true;
    AnnotationTargetKind[] targetKinds = null;
    private Signature.FormalTypeParameter[] formalsForResolution = null;

    public AsmDelegate(ReferenceType rt, InputStream inputStream) {
        super(rt, false);
        this.w = rt.getWorld();
        try {
            new ClassReader(inputStream).accept((ClassVisitor)new TypeVisitor(this), AsmConstants.ajAttributes, true);
            inputStream.close();
            if ((this.classModifiers & 0x1000) > 0) {
                this.classModifiers -= 4096;
            }
            if ((this.classModifiers & 0x20000) > 0) {
                this.classModifiers -= 131072;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.setSourceContext(new SourceContextImpl(this));
    }

    public boolean isAnnotationStyleAspect() {
        return false;
    }

    public boolean canAnnotationTargetType() {
        return this.canAnnotationTargetType;
    }

    public AnnotationTargetKind[] getAnnotationTargetKinds() {
        return this.targetKinds;
    }

    public boolean isGeneric() {
        return this.isGenericType;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public boolean isNested() {
        return this.isNested;
    }

    public boolean hasAnnotation(UnresolvedType ofType) {
        this.ensureAnnotationsUnpacked();
        for (int i = 0; i < this.annotationTypes.length; ++i) {
            if (!this.annotationTypes[i].equals(ofType)) continue;
            return true;
        }
        return false;
    }

    public AnnotationX[] getAnnotations() {
        this.ensureAnnotationXsUnpacked();
        return this.annotationXs;
    }

    public ResolvedType[] getAnnotationTypes() {
        this.ensureAnnotationsUnpacked();
        return this.annotationTypes;
    }

    private void ensureAnnotationXsUnpacked() {
        if ((this.bitflag & 0x80) != 0 && (this.bitflag & 0x100) != 0) {
            return;
        }
        this.ensureAnnotationsUnpacked();
        if (this.annotations.size() == 0) {
            this.annotationXs = AnnotationX.NONE;
        } else {
            this.annotationXs = new AnnotationX[this.annotations.size()];
            int pos = 0;
            Iterator iter = this.annotations.iterator();
            while (iter.hasNext()) {
                AnnotationAJ element = (AnnotationAJ)iter.next();
                this.annotationXs[pos++] = new AnnotationX(element, this.w);
            }
            this.annotations = null;
        }
        this.bitflag |= 0x100;
    }

    private void ensureAnnotationsUnpacked() {
        if ((this.bitflag & 0x80) != 0) {
            return;
        }
        if (this.annotations.size() == 0) {
            this.annotationTypes = ResolvedType.NONE;
        } else {
            this.annotationTypes = new ResolvedType[this.annotations.size()];
            int pos = 0;
            Iterator iter = this.annotations.iterator();
            while (iter.hasNext()) {
                AnnotationAJ element = (AnnotationAJ)iter.next();
                this.annotationTypes[pos++] = this.w.resolve(UnresolvedType.forSignature(element.getTypeSignature()));
            }
        }
        this.bitflag |= 0x80;
    }

    public Signature.FormalTypeParameter[] getAllFormals() {
        this.ensureSignatureUnpacked();
        if (this.formalsForResolution == null) {
            return new Signature.FormalTypeParameter[0];
        }
        return this.formalsForResolution;
    }

    public AjAttribute[] getAttributes(String name) {
        ArrayList<AjAttribute> results = new ArrayList<AjAttribute>();
        Iterator iter = this.attributes.iterator();
        while (iter.hasNext()) {
            Attribute element = (Attribute)iter.next();
            if (!element.type.equals(name) || !(element instanceof AjASMAttribute)) continue;
            results.add(((AjASMAttribute)element).unpack(this));
        }
        if (results.size() > 0) {
            return results.toArray(new AjAttribute[0]);
        }
        return null;
    }

    public String[] getAttributeNames() {
        String[] strs = new String[this.attributes.size()];
        int i = 0;
        Iterator iter = this.attributes.iterator();
        while (iter.hasNext()) {
            Attribute element = (Attribute)iter.next();
            strs[i++] = element.type;
        }
        return strs;
    }

    public ISourceContext getSourceContext() {
        if ((this.bitflag & 0x10) == 0) {
            this.bitflag |= 0x10;
            AjASMAttribute foundIt = null;
            Iterator iter = this.attributes.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof AjASMAttribute)) continue;
                AjASMAttribute element = (AjASMAttribute)((Object)o);
                if (!element.type.equals("org.aspectj.weaver.SourceContext")) continue;
                foundIt = element;
                AjAttribute.SourceContextAttribute sca = (AjAttribute.SourceContextAttribute)element.unpack(this);
                if (super.getSourceContext() == SourceContextImpl.UNKNOWN_SOURCE_CONTEXT) {
                    super.setSourceContext(new SourceContextImpl(this));
                }
                ((SourceContextImpl)super.getSourceContext()).configureFromAttribute(sca.getSourceFileName(), sca.getLineBreaks());
                break;
            }
            if (foundIt != null) {
                this.attributes.remove((Object)foundIt);
            }
        }
        return super.getSourceContext();
    }

    public WeaverStateInfo getWeaverState() {
        if ((this.bitflag & 0x20) == 0) {
            Iterator iter = this.attributes.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof AjASMAttribute)) continue;
                AjASMAttribute element = (AjASMAttribute)((Object)o);
                if (!element.type.equals("org.aspectj.weaver.WeaverState")) continue;
                AjAttribute.WeaverState wsInfo = (AjAttribute.WeaverState)element.unpack(this);
                this.weaverStateInfo = wsInfo.reify();
                break;
            }
            this.bitflag |= 0x20;
        }
        return this.weaverStateInfo;
    }

    public String getDeclaredGenericSignature() {
        return this.declaredSignature;
    }

    public Collection getTypeMungers() {
        if ((this.bitflag & 4) == 0) {
            this.typeMungers = new ArrayList();
            Iterator iter = this.attributes.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof AjASMAttribute)) continue;
                AjASMAttribute element = (AjASMAttribute)((Object)o);
                if (!element.type.equals("org.aspectj.weaver.TypeMunger")) continue;
                AjAttribute.TypeMunger typeMunger = (AjAttribute.TypeMunger)element.unpack(this);
                this.typeMungers.add(typeMunger.reify(this.w, this.getResolvedTypeX()));
            }
            this.bitflag |= 4;
        }
        return this.typeMungers;
    }

    public Collection getPrivilegedAccesses() {
        if ((this.bitflag & 8) == 0) {
            this.privilegedAccesses = new ArrayList();
            Iterator iter = this.attributes.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof AjASMAttribute)) continue;
                AjASMAttribute element = (AjASMAttribute)((Object)o);
                if (!element.type.equals("org.aspectj.weaver.Privileged")) continue;
                AjAttribute.PrivilegedAttribute privilegedAttribute = (AjAttribute.PrivilegedAttribute)element.unpack(this);
                ResolvedMember[] pas = privilegedAttribute.getAccessedMembers();
                for (int i = 0; i < pas.length; ++i) {
                    this.privilegedAccesses.add(pas[i]);
                }
            }
            this.bitflag |= 8;
        }
        return this.privilegedAccesses;
    }

    public TypeVariable[] getTypeVariables() {
        this.ensureSignatureUnpacked();
        return this.typeVariables;
    }

    private void ensureSignatureUnpacked() {
        if ((this.bitflag & 0x40) != 0) {
            return;
        }
        this.typeVariables = TypeVariable.NONE;
        if (!this.getResolvedTypeX().getWorld().isInJava5Mode()) {
            this.bitflag |= 0x40;
            return;
        }
        if (this.declaredSignature != null) {
            GenericSignatureParser parser = new GenericSignatureParser();
            Signature.ClassSignature cSig = parser.parseAsClassSignature(this.declaredSignature);
            this.typeVariables = new TypeVariable[cSig.formalTypeParameters.length];
            for (int i = 0; i < this.typeVariables.length; ++i) {
                Signature.FormalTypeParameter ftp = cSig.formalTypeParameters[i];
                try {
                    this.typeVariables[i] = BcelGenericSignatureToTypeXConverter.formalTypeParameter2TypeVariable(ftp, cSig.formalTypeParameters, this.getResolvedTypeX().getWorld());
                    continue;
                }
                catch (BcelGenericSignatureToTypeXConverter.GenericSignatureFormatException e) {
                    throw new IllegalStateException("While getting the type variables for type " + this.toString() + " with generic signature " + cSig + " the following error condition was detected: " + e.getMessage());
                }
            }
            if (cSig != null) {
                Signature.FormalTypeParameter[] extraFormals;
                this.formalsForResolution = cSig.formalTypeParameters;
                if (this.isNested() && (extraFormals = this.getFormalTypeParametersFromOuterClass()).length > 0) {
                    int i;
                    ArrayList<Signature.FormalTypeParameter> allFormals = new ArrayList<Signature.FormalTypeParameter>();
                    for (i = 0; i < this.formalsForResolution.length; ++i) {
                        allFormals.add(this.formalsForResolution[i]);
                    }
                    for (i = 0; i < extraFormals.length; ++i) {
                        allFormals.add(extraFormals[i]);
                    }
                    this.formalsForResolution = new Signature.FormalTypeParameter[allFormals.size()];
                    allFormals.toArray(this.formalsForResolution);
                }
                Signature.ClassTypeSignature superSig = cSig.superclassSignature;
                try {
                    this.superclassType = BcelGenericSignatureToTypeXConverter.classTypeSignature2TypeX(superSig, this.formalsForResolution, this.getResolvedTypeX().getWorld());
                    this.bitflag |= 0x200;
                }
                catch (BcelGenericSignatureToTypeXConverter.GenericSignatureFormatException e) {
                    throw new IllegalStateException("While determing the generic superclass of " + this.getResolvedTypeX() + " with generic signature " + this.declaredSignature + " the following error was detected: " + e.getMessage());
                }
                this.interfaceTypes = new ResolvedType[cSig.superInterfaceSignatures.length];
                for (int i = 0; i < cSig.superInterfaceSignatures.length; ++i) {
                    try {
                        this.interfaceTypes[i] = BcelGenericSignatureToTypeXConverter.classTypeSignature2TypeX(cSig.superInterfaceSignatures[i], this.formalsForResolution, this.getResolvedTypeX().getWorld());
                        continue;
                    }
                    catch (BcelGenericSignatureToTypeXConverter.GenericSignatureFormatException e) {
                        throw new IllegalStateException("While determing the generic superinterfaces of " + this.getResolvedTypeX() + " with generic signature " + this.declaredSignature + " the following error was detected: " + e.getMessage());
                    }
                }
                if (this.isGeneric()) {
                    ReferenceType genericType = (ReferenceType)this.resolvedTypeX.getGenericType();
                    genericType.setStartPos(this.resolvedTypeX.getStartPos());
                    this.resolvedTypeX = genericType;
                }
            }
        }
        this.bitflag |= 0x40;
    }

    private ReferenceType getOuterClass() {
        if (!this.isNested()) {
            throw new IllegalStateException("Can't get the outer class of a non-nested type");
        }
        int lastDollar = this.getResolvedTypeX().getName().lastIndexOf(36);
        String superClassName = this.getResolvedTypeX().getName().substring(0, lastDollar);
        UnresolvedType outer = UnresolvedType.forName(superClassName);
        return (ReferenceType)outer.resolve(this.getResolvedTypeX().getWorld());
    }

    private Signature.FormalTypeParameter[] getFormalTypeParametersFromOuterClass() {
        Signature.ClassSignature outerSig;
        ArrayList<Signature.FormalTypeParameter> typeParameters = new ArrayList<Signature.FormalTypeParameter>();
        ReferenceType outer = this.getOuterClass();
        ReferenceTypeDelegate outerDelegate = outer.getDelegate();
        if (!(outerDelegate instanceof AsmDelegate)) {
            throw new IllegalStateException("How come we're in AsmObjectType resolving an inner type of something that is NOT a AsmObjectType??");
        }
        AsmDelegate outerObjectType = (AsmDelegate)outerDelegate;
        if (outerObjectType.isNested()) {
            Signature.FormalTypeParameter[] parentParams = outerObjectType.getFormalTypeParametersFromOuterClass();
            for (int i = 0; i < parentParams.length; ++i) {
                typeParameters.add(parentParams[i]);
            }
        }
        GenericSignatureParser parser = new GenericSignatureParser();
        String sig = outerObjectType.getDeclaredGenericSignature();
        if (sig != null && (outerSig = parser.parseAsClassSignature(sig)) != null) {
            for (int i = 0; i < outerSig.formalTypeParameters.length; ++i) {
                typeParameters.add(outerSig.formalTypeParameters[i]);
            }
        }
        Signature.FormalTypeParameter[] ret = new Signature.FormalTypeParameter[typeParameters.size()];
        typeParameters.toArray(ret);
        return ret;
    }

    public boolean isInterface() {
        return (this.classModifiers & 0x200) != 0;
    }

    public String getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public boolean isAnnotationWithRuntimeRetention() {
        return this.isRuntimeRetention;
    }

    public boolean isAnnotation() {
        return (this.classModifiers & 0x2000) != 0;
    }

    public boolean isEnum() {
        return (this.classModifiers & 0x4000) != 0;
    }

    public int getModifiers() {
        return this.classModifiers;
    }

    public ResolvedMember[] getDeclaredFields() {
        this.ensureSignatureUnpacked();
        if ((this.bitflag & 0x400) == 0) {
            for (int i = 0; i < this.fields.length; ++i) {
                ((ResolvedMemberImpl)this.fields[i]).setDeclaringType(this.getResolvedTypeX());
            }
            this.bitflag |= 0x400;
        }
        return this.fields;
    }

    public ResolvedType[] getDeclaredInterfaces() {
        if (this.interfaceTypes == null) {
            if (this.interfaceNames == null || this.interfaceNames.length == 0) {
                this.interfaceTypes = new ResolvedType[0];
            } else {
                this.interfaceTypes = new ResolvedType[this.interfaceNames.length];
                for (int i = 0; i < this.interfaceNames.length; ++i) {
                    this.interfaceTypes[i] = this.w.resolve(this.interfaceNames[i].replace('/', '.'));
                }
            }
            this.interfaceNames = null;
            this.ensureSignatureUnpacked();
        }
        return this.interfaceTypes;
    }

    public ResolvedMember[] getDeclaredMethods() {
        this.ensureSignatureUnpacked();
        if ((this.bitflag & 0x800) == 0) {
            for (int i = 0; i < this.methods.length; ++i) {
                ((ResolvedMemberImpl)this.methods[i]).setDeclaringType(this.getResolvedTypeX());
            }
            this.bitflag |= 0x800;
        }
        return this.methods;
    }

    public ResolvedMember[] getDeclaredPointcuts() {
        if ((this.bitflag & 1) == 0) {
            ArrayList<ResolvedPointcutDefinition> pcts = new ArrayList<ResolvedPointcutDefinition>();
            ArrayList<AjASMAttribute> forRemoval = new ArrayList<AjASMAttribute>();
            Iterator iter = this.attributes.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof AjASMAttribute)) continue;
                AjASMAttribute element = (AjASMAttribute)((Object)o);
                if (!element.type.equals("org.aspectj.weaver.PointcutDeclaration")) continue;
                AjAttribute.PointcutDeclarationAttribute pointcut = (AjAttribute.PointcutDeclarationAttribute)element.unpack(this);
                pcts.add(pointcut.reify());
                forRemoval.add(element);
            }
            this.pointcuts = pcts.toArray(new ResolvedPointcutDefinition[0]);
            this.attributes.removeAll(forRemoval);
            this.bitflag |= 1;
        }
        return this.pointcuts;
    }

    public Collection getDeclares() {
        if ((this.bitflag & 2) == 0) {
            this.declares = new ArrayList();
            ArrayList<AjASMAttribute> forRemoval = new ArrayList<AjASMAttribute>();
            Iterator iter = this.attributes.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof AjASMAttribute)) continue;
                AjASMAttribute element = (AjASMAttribute)((Object)o);
                if (!element.type.equals("org.aspectj.weaver.Declare")) continue;
                AjAttribute.DeclareAttribute declare = (AjAttribute.DeclareAttribute)element.unpack(this);
                this.declares.add(declare.getDeclare());
                forRemoval.add(element);
            }
            this.attributes.removeAll(forRemoval);
            this.bitflag |= 2;
        }
        return this.declares;
    }

    public ResolvedType getSuperclass() {
        if ((this.bitflag & 0x200) == 0) {
            this.superclassType = this.superclassName == null ? null : this.w.resolve(this.superclassName.replace('/', '.'));
            this.ensureSignatureUnpacked();
            this.superclassName = null;
            this.bitflag |= 0x200;
        }
        return this.superclassType;
    }

    public PerClause getPerClause() {
        return this.perClause;
    }

    public boolean isAspect() {
        return this.isAspect;
    }

    World getWorld() {
        return this.w;
    }

    public void addAnnotation(AnnotationX annotationX) {
    }

    public void ensureDelegateConsistent() {
    }
}

