/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bandana;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.bandana.BandanaPersister;
import com.thoughtworks.xstream.XStream;
import java.util.Iterator;
import java.util.Map;

public class DefaultBandanaManager
implements BandanaManager {
    private BandanaPersister persister;
    private XStream xstream;

    public DefaultBandanaManager(BandanaPersister persister) {
        this.persister = persister;
        this.xstream = new XStream();
    }

    public void init() {
    }

    public Object getValue(BandanaContext context, String key) {
        return this.getValue(context, key, true);
    }

    public Object getValue(BandanaContext context, String key, boolean lookup) {
        if (context == null) {
            return null;
        }
        Object value = this.persister.retrieve(context, key);
        if (value != null) {
            return value;
        }
        if (lookup && context.hasParentContext()) {
            return this.getValue(context.getParentContext(), key, true);
        }
        return null;
    }

    public String exportValues(BandanaContext context) {
        Map values = this.persister.retrieve(context);
        return this.xstream.toXML((Object)values);
    }

    public void importValues(BandanaContext context, String xmlValues) {
        this.persister.remove(context);
        Map values = (Map)this.xstream.fromXML(xmlValues);
        Iterator i = values.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.persister.store(context, (String)e.getKey(), (String)e.getValue());
        }
    }

    public void setValue(BandanaContext context, String key, Object value) {
        this.persister.store(context, key, value);
    }
}

