/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie;

import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.bonnie.LuceneException;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.DelayCloseIndexSearcher;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;

public class ConcurrentLuceneConnection
implements ILuceneConnection {
    private static Logger log = Logger.getLogger((Class)ConcurrentLuceneConnection.class);
    private transient Directory directory;
    private final Analyzer analyzerForIndexing;
    private final ILuceneConnection.Configuration configuration;
    private final Lock indexWriteLock = new ReentrantLock();
    private final Lock searcherCreationLock = new ReentrantLock();
    private final AtomicBoolean batchMode = new AtomicBoolean(false);
    private DelayCloseIndexSearcher currentSearcher;

    public ConcurrentLuceneConnection(Directory directory, Analyzer analyzer, ILuceneConnection.Configuration configuration) {
        this.directory = directory;
        this.analyzerForIndexing = analyzer;
        this.configuration = configuration;
    }

    public ConcurrentLuceneConnection(File path, Analyzer analyzer, ILuceneConnection.Configuration configuration) {
        this(ConcurrentLuceneConnection.getDirectory(path), analyzer, configuration);
    }

    public int getNumDocs() {
        return (Integer)this.withReader(new ILuceneConnection.ReaderAction(){

            public Object perform(IndexReader reader) {
                return new Integer(reader.numDocs());
            }
        });
    }

    public boolean isIndexCreated() {
        try {
            return IndexReader.indexExists((Directory)this.directory);
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
    }

    public IndexSearcher leakSearcher() {
        try {
            return this.getOpenedSearcher();
        }
        catch (Throwable e) {
            this.flipCurrentSearcher();
            this.throwLuceneException(e);
            throw new IllegalStateException("Exception should have been thrown.");
        }
    }

    public void optimize() throws LuceneException {
        this.withWriter(new ILuceneConnection.WriterAction(){

            public void perform(IndexWriter writer) throws IOException {
                writer.optimize();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recreateIndexDirectory() {
        this.indexWriteLock.lock();
        try {
            this.directory.close();
            if (this.directory instanceof FSDirectory) {
                this.directory = FSDirectory.getDirectory((File)((FSDirectory)this.directory).getFile());
            } else if (this.directory instanceof RAMDirectory) {
                this.directory = new RAMDirectory();
            }
            new IndexWriter(this.directory, null, true).close();
        }
        catch (IOException e) {
            throw new LuceneException("Cannot create index directory.", e);
        }
        finally {
            try {
                this.flipCurrentSearcher();
            }
            finally {
                this.indexWriteLock.unlock();
            }
        }
    }

    public void close() {
        this.flipCurrentSearcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withSearch(ILuceneConnection.SearcherAction action) throws LuceneException {
        try {
            DelayCloseIndexSearcher searcher = this.getOpenedSearcher();
            try {
                boolean b = action.perform(searcher);
                if (!b) {
                    throw new UnsupportedOperationException("Searchers are always closed. The searcherAction should always return true, we do not allow them to control closing of the searchers");
                }
            }
            finally {
                this.closeSearcher(searcher);
            }
        }
        catch (Throwable e) {
            this.flipCurrentSearcher();
            this.throwLuceneException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object withReader(ILuceneConnection.ReaderAction action) throws LuceneException {
        DelayCloseIndexSearcher searcher = this.getOpenedSearcher();
        try {
            Object object = action.perform(searcher.getIndexReader());
            this.closeSearcher(searcher);
            return object;
        }
        catch (Throwable throwable) {
            try {
                this.closeSearcher(searcher);
                throw throwable;
            }
            catch (Throwable e) {
                this.flipCurrentSearcher();
                this.throwLuceneException(e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withReaderAndDeletes(ILuceneConnection.ReaderAction action) throws LuceneException {
        this.indexWriteLock.lock();
        IndexReader deleter = null;
        try {
            deleter = this.constructIndexDeleter();
            action.perform(deleter);
            this.flipCurrentSearcher();
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
        finally {
            try {
                this.closeReader(deleter);
            }
            finally {
                this.indexWriteLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withWriter(ILuceneConnection.WriterAction action) throws LuceneException {
        this.indexWriteLock.lock();
        IndexWriter writer = null;
        try {
            writer = this.constructIndexWriter();
            action.perform(writer);
            this.flipCurrentSearcher();
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
        finally {
            try {
                this.closeWriter(writer);
            }
            finally {
                this.indexWriteLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withDeleteAndWrites(ILuceneConnection.ReaderAction readerAction, ILuceneConnection.WriterAction writerAction) throws LuceneException {
        this.indexWriteLock.lock();
        try {
            this.withReaderAndDeletes(readerAction);
            this.withWriter(writerAction);
        }
        finally {
            this.indexWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withBatchUpdate(ILuceneConnection.BatchUpdateAction action) {
        this.indexWriteLock.lock();
        try {
            this.batchMode.set(true);
            action.perform();
        }
        catch (Exception e) {
            this.throwLuceneException(e);
        }
        finally {
            this.batchMode.set(false);
            this.indexWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flipCurrentSearcher() {
        block9: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Closing current searcher..");
            }
            this.searcherCreationLock.lock();
            try {
                if (this.currentSearcher == null) break block9;
                try {
                    this.currentSearcher.closeWhenDone();
                }
                catch (Exception e) {
                    log.error((Object)"Error occured attempting to close Index searcher", (Throwable)e);
                }
                finally {
                    this.currentSearcher = null;
                }
            }
            finally {
                this.searcherCreationLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DelayCloseIndexSearcher getOpenedSearcher() throws IOException {
        this.searcherCreationLock.lock();
        try {
            if (this.currentSearcher == null) {
                this.currentSearcher = new DelayCloseIndexSearcher(this.directory);
            }
            this.currentSearcher.open();
            DelayCloseIndexSearcher delayCloseIndexSearcher = this.currentSearcher;
            return delayCloseIndexSearcher;
        }
        finally {
            this.searcherCreationLock.unlock();
        }
    }

    private IndexReader constructIndexDeleter() {
        try {
            return IndexReader.open((Directory)this.directory);
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
    }

    private void closeReader(IndexReader reader) {
        try {
            if (reader != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(Thread.currentThread().getName() + "## closing reader"));
                }
                reader.close();
            }
        }
        catch (IOException e) {
            log.error((Object)("Error closing reader. " + e), (Throwable)e);
        }
    }

    private void closeSearcher(IndexSearcher searcher) {
        try {
            if (searcher != null) {
                searcher.close();
            }
        }
        catch (IOException e) {
            log.error((Object)"Error occurred while closing searcher.", (Throwable)e);
        }
    }

    private void closeWriter(IndexWriter writer) {
        try {
            if (writer != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"## closing writer");
                }
                writer.close();
            } else {
                log.warn((Object)"## trying to close null writer.");
            }
        }
        catch (IOException e) {
            log.error((Object)("Error closing writer. " + e), (Throwable)e);
        }
    }

    private IndexWriter constructIndexWriter() throws LuceneException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)(Thread.currentThread().getName() + "## opening writer"));
            }
            IndexWriter indexWriter = new IndexWriter(this.directory, this.analyzerForIndexing, false);
            if (this.batchMode.get()) {
                indexWriter.setMaxBufferedDocs(this.configuration.getBatchMaxBufferedDocs());
                indexWriter.setMaxMergeDocs(this.configuration.getBatchMaxMergeDocs());
                indexWriter.setMergeFactor(this.configuration.getBatchMergeFactor());
            } else {
                indexWriter.setMaxBufferedDocs(this.configuration.getInteractiveMaxBufferedDocs());
                indexWriter.setMaxMergeDocs(this.configuration.getInteractiveMaxMergeDocs());
                indexWriter.setMergeFactor(this.configuration.getInteractiveMergeFactor());
            }
            indexWriter.setMaxFieldLength(this.configuration.getMaxFieldLength());
            return indexWriter;
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
    }

    private void throwLuceneException(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new LuceneException(e);
    }

    private static Directory getDirectory(File path) {
        try {
            return FSDirectory.getDirectory((File)path);
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
    }
}

