/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie;

import com.atlassian.bonnie.LuceneException;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;

public interface ILuceneConnection {
    public static final Configuration DEFAULT_CONFIGURATION = new Configuration(){

        public int getBatchMergeFactor() {
            return 50;
        }

        public int getBatchMaxMergeDocs() {
            return Integer.MAX_VALUE;
        }

        public int getBatchMaxBufferedDocs() {
            return 300;
        }

        public int getInteractiveMergeFactor() {
            return 4;
        }

        public int getInteractiveMaxMergeDocs() {
            return 5000;
        }

        public int getInteractiveMaxBufferedDocs() {
            return 300;
        }

        public int getMaxFieldLength() {
            return 1000000;
        }

        public boolean isCompoundIndexFileFormat() {
            return true;
        }
    };

    public void withSearch(SearcherAction var1) throws LuceneException;

    public Object withReader(ReaderAction var1) throws LuceneException;

    public void withReaderAndDeletes(ReaderAction var1) throws LuceneException;

    public void withWriter(WriterAction var1) throws LuceneException;

    public void withDeleteAndWrites(ReaderAction var1, WriterAction var2) throws LuceneException;

    public void withBatchUpdate(BatchUpdateAction var1);

    public void optimize() throws LuceneException;

    public void close();

    public int getNumDocs();

    public boolean isIndexCreated();

    public void recreateIndexDirectory();

    public IndexSearcher leakSearcher();

    public static interface Configuration {
        public int getInteractiveMergeFactor();

        public int getInteractiveMaxMergeDocs();

        public int getInteractiveMaxBufferedDocs();

        public int getBatchMergeFactor();

        public int getBatchMaxMergeDocs();

        public int getBatchMaxBufferedDocs();

        public int getMaxFieldLength();

        public boolean isCompoundIndexFileFormat();
    }

    public static interface BatchUpdateAction {
        public void perform() throws Exception;
    }

    public static interface WriterAction {
        public void perform(IndexWriter var1) throws IOException;
    }

    public static interface ReaderAction {
        public Object perform(IndexReader var1) throws IOException;
    }

    public static interface SearcherAction {
        public boolean perform(IndexSearcher var1) throws IOException;
    }
}

