/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.search;

import com.atlassian.bonnie.AnyTypeObjectDao;
import com.atlassian.bonnie.Handle;
import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.DocumentBuilder;
import com.atlassian.bonnie.search.DocumentPostProcessor;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.core.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Category;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class BaseDocumentBuilder
implements DocumentBuilder {
    private static final Category log = Category.getInstance((Class)BaseDocumentBuilder.class);
    private final AnyTypeObjectDao anyTypeObjectDao;
    private final List extractors;
    private final List postProcessors;
    public static final String TYPE_FIELD = "type";
    public static final String URL_PATH_FIELD = "urlPath";
    private static final int CONTENT_BODY_MAX_SIZE = new ContentBodyMaxSizeSystemProperty().getValue();

    public BaseDocumentBuilder(AnyTypeObjectDao anyTypeObjectDao, List extractors, List postProcessors) {
        if (extractors == null) {
            throw new IllegalArgumentException("extractors is required.");
        }
        if (postProcessors == null) {
            throw new IllegalArgumentException("postProcessors is required.");
        }
        if (anyTypeObjectDao == null) {
            throw new IllegalArgumentException("anyTypeObjectDao is required.");
        }
        this.anyTypeObjectDao = anyTypeObjectDao;
        this.extractors = Collections.unmodifiableList(new ArrayList(extractors));
        this.postProcessors = Collections.unmodifiableList(new ArrayList(postProcessors));
    }

    public Document getDocument(Searchable searchable) {
        Document document = this.getInitialDocument(searchable);
        StringBuffer contentBody = new StringBuffer();
        Iterator it = this.extractors.iterator();
        while (it.hasNext()) {
            Extractor extractor = (Extractor)it.next();
            try {
                extractor.addFields(document, contentBody, searchable);
            }
            catch (RuntimeException e) {
                log.error((Object)("Error extracting search fields from " + searchable + " using " + extractor + ": " + e.getMessage()), (Throwable)e);
            }
        }
        if (contentBody.length() > 0) {
            Field.Store store = contentBody.length() > CONTENT_BODY_MAX_SIZE ? Field.Store.NO : Field.Store.YES;
            document.add((Fieldable)new Field("contentBody", contentBody.toString(), store, Field.Index.TOKENIZED));
        }
        Iterator iterator = this.postProcessors.iterator();
        while (iterator.hasNext()) {
            DocumentPostProcessor documentPostProcessor = (DocumentPostProcessor)iterator.next();
            documentPostProcessor.process(document);
        }
        return document;
    }

    protected Document getInitialDocument(Searchable searchable) {
        Document document = new Document();
        Field handleField = new Field("handle", ((Object)this.getHandle(searchable)).toString(), Field.Store.YES, Field.Index.UN_TOKENIZED);
        document.add((Fieldable)handleField);
        Field classNameField = new Field("classname", ObjectUtils.getTrueClass((Object)searchable).getName(), Field.Store.NO, Field.Index.UN_TOKENIZED);
        document.add((Fieldable)classNameField);
        try {
            Object type = PropertyUtils.getProperty((Object)searchable, (String)TYPE_FIELD);
            if (type != null) {
                document.add((Fieldable)new Field(TYPE_FIELD, type.toString(), Field.Store.YES, Field.Index.UN_TOKENIZED));
            }
        }
        catch (Exception e) {
            log.warn((Object)("Error getting metadata: Reason '" + e.getMessage() + "'"));
        }
        try {
            Object urlPath = PropertyUtils.getProperty((Object)searchable, (String)URL_PATH_FIELD);
            if (urlPath != null) {
                document.add((Fieldable)new Field(URL_PATH_FIELD, urlPath.toString(), Field.Store.YES, Field.Index.UN_TOKENIZED));
            }
        }
        catch (Exception e) {
            log.warn((Object)("Error getting metadata: Reason '" + e.getMessage() + "'"));
        }
        return document;
    }

    public Handle getHandle(Object obj) {
        return this.anyTypeObjectDao.getHandle(obj);
    }

    public static class FieldName {
        public static final String HANDLE = "handle";
        public static final String CLASS_NAME = "classname";
        public static final String CONTENT_BODY = "contentBody";
    }

    static class ContentBodyMaxSizeSystemProperty {
        public static final int DEFAULT = 0x100000;
        private final int value;

        public ContentBodyMaxSizeSystemProperty() {
            int value;
            String contentBodyMaxSize = System.getProperty("atlassian.indexing.contentbody.maxsize");
            if (contentBodyMaxSize != null) {
                try {
                    value = Integer.parseInt(contentBodyMaxSize);
                }
                catch (NumberFormatException e) {
                    value = 0x100000;
                }
            } else {
                value = 0x100000;
            }
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

