/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.search;

import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.bonnie.Indexer;
import com.atlassian.bonnie.LuceneConnection;
import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.DocumentBuilder;
import java.io.IOException;
import org.apache.log4j.Category;
import org.apache.log4j.MDC;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;

public class LuceneIndexer
implements Indexer {
    public static final Category LOG = Category.getInstance((Class)LuceneIndexer.class);
    private LuceneConnection luceneConnection;
    private DocumentBuilder documentBuilder;

    public void index(final Searchable obj) {
        if (!obj.isIndexable()) {
            return;
        }
        this.unIndex(obj);
        this.luceneConnection.withWriter(new ILuceneConnection.WriterAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(IndexWriter indexWriter) throws IOException {
                try {
                    MDC.put((String)"Indexing", (Object)obj.toString());
                    indexWriter.addDocument(LuceneIndexer.this.documentBuilder.getDocument(obj));
                }
                finally {
                    MDC.remove((String)"Indexing");
                }
            }
        });
    }

    public void unIndex(final Searchable obj) {
        this.luceneConnection.withReaderAndDeletes(new ILuceneConnection.ReaderAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object perform(IndexReader indexReader) throws IOException {
                try {
                    MDC.put((String)"Unindexing", (Object)obj.toString());
                    Term t = new Term("handle", ((Object)LuceneIndexer.this.documentBuilder.getHandle(obj)).toString());
                    indexReader.deleteDocuments(t);
                    Object var3_3 = null;
                    return var3_3;
                }
                finally {
                    MDC.remove((String)"Unindexing");
                }
            }
        });
    }

    public void reIndex(Searchable obj) {
        this.unIndex(obj);
        this.index(obj);
    }

    public void unIndexAll() {
        try {
            this.luceneConnection.truncateIndex();
        }
        catch (IOException e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }

    public void setLuceneConnection(LuceneConnection luceneConnection) {
        this.luceneConnection = luceneConnection;
    }

    public void setDocumentBuilder(DocumentBuilder documentBuilder) {
        this.documentBuilder = documentBuilder;
    }
}

