/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.search.extractor;

import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.bonnie.search.SearchableAttachment;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class AttachmentMetadataExtractor
implements Extractor {
    public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable) {
        if (searchable instanceof SearchableAttachment) {
            SearchableAttachment attachment = (SearchableAttachment)searchable;
            if (attachment.getFileName() != null && !"".equals(attachment.getFileName())) {
                Field fileNameField = new Field("filename", attachment.getFileName(), Field.Store.YES, Field.Index.TOKENIZED);
                document.add((Fieldable)fileNameField);
                document.add((Fieldable)new Field("title", attachment.getFileName(), Field.Store.YES, Field.Index.NO));
            }
            if (attachment.getComment() != null && !"".equals(attachment.getComment())) {
                Field commentField = new Field("comment", attachment.getComment(), Field.Store.YES, Field.Index.TOKENIZED);
                document.add((Fieldable)commentField);
                defaultSearchableText.append(" ").append(attachment.getComment());
            }
            if (attachment.getNiceType() != null && !"".equals(attachment.getNiceType())) {
                document.add((Fieldable)new Field("niceType", attachment.getNiceType(), Field.Store.YES, Field.Index.NO));
            }
            if (attachment.getDownloadPath() != null && !"".equals(attachment.getDownloadPath())) {
                document.add((Fieldable)new Field("downloadPath", attachment.getDownloadPath(), Field.Store.YES, Field.Index.NO));
            }
            if (attachment.getNiceFileSize() != null && !"".equals(attachment.getNiceFileSize())) {
                document.add((Fieldable)new Field("niceFileSize", attachment.getNiceFileSize(), Field.Store.YES, Field.Index.NO));
            }
        }
    }

    public static class FieldName {
        public static final String NICE_TYPE = "niceType";
        public static final String DOWNLOAD_PATH = "downloadPath";
        public static final String NICE_FILE_SIZE = "niceFileSize";
    }
}

