/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.search.extractor;

import com.atlassian.bonnie.search.SearchableAttachment;
import com.atlassian.bonnie.search.extractor.BaseAttachmentContentExtractor;
import com.atlassian.bonnie.search.extractor.ExtractorException;
import com.atlassian.bonnie.search.extractor.PowerPointListener;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Category;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;

public class MsPowerpointContentExtractor
extends BaseAttachmentContentExtractor {
    public static final Category log = Category.getInstance((Class)MsPowerpointContentExtractor.class);
    private static final String[] CONTENT_TYPES = new String[]{"application/powerpoint", "application/mspowerpoint", "application/x-mspowerpoint", "application/vnd.ms-powerpoint"};
    private static final String[] EXTENSIONS = new String[]{"ppt"};

    protected String[] getMatchingContentTypes() {
        return CONTENT_TYPES;
    }

    protected String[] getMatchingFileExtensions() {
        return EXTENSIONS;
    }

    protected String extractText(InputStream is, SearchableAttachment attachment) throws ExtractorException {
        StringBuffer content = new StringBuffer();
        POIFSReader r = new POIFSReader();
        r.registerListener((POIFSReaderListener)new PowerPointListener(content));
        try {
            r.read(is);
        }
        catch (IOException e) {
            throw new ExtractorException("Error reading content of Powerpoint document: " + e.getMessage(), e);
        }
        return content.toString();
    }
}

