/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.search.extractor;

import com.atlassian.bonnie.search.SearchableAttachment;
import com.atlassian.bonnie.search.extractor.BaseAttachmentContentExtractor;
import com.atlassian.bonnie.search.extractor.ExtractorException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.log4j.Category;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;

public class PdfContentExtractor
extends BaseAttachmentContentExtractor {
    public static final Category log = Category.getInstance((Class)PdfContentExtractor.class);
    private static final String[] EXTENSIONS = new String[]{"pdf"};
    private static final String[] CONTENT_TYPES = new String[]{"application/pdf"};

    protected String[] getMatchingContentTypes() {
        return CONTENT_TYPES;
    }

    protected String[] getMatchingFileExtensions() {
        return EXTENSIONS;
    }

    protected String extractText(InputStream is, SearchableAttachment attachment) throws ExtractorException {
        PDDocument pdfDocument = null;
        try {
            pdfDocument = PDDocument.load((InputStream)is);
            if (pdfDocument.isEncrypted()) {
                pdfDocument.decrypt("");
            }
            StringWriter writer = new StringWriter();
            PDFTextStripper stripper = new PDFTextStripper();
            stripper.writeText(pdfDocument, (Writer)writer);
            writer.close();
            String string = writer.getBuffer().toString();
            return string;
        }
        catch (CryptographyException e) {
            throw new ExtractorException("Could not decrypt PDF document: " + e.getMessage(), e);
        }
        catch (InvalidPasswordException e) {
            throw new ExtractorException("Password required for encrypted PDF document", e);
        }
        catch (Exception e) {
            throw new ExtractorException("Error getting content of PDF document", e);
        }
        finally {
            if (pdfDocument != null) {
                try {
                    pdfDocument.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

