/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.search.summary;

import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.bonnie.LuceneConnection;
import com.atlassian.bonnie.analyzer.LuceneAnalyzerFactory;
import com.atlassian.bonnie.search.summary.Excerpt;
import com.atlassian.bonnie.search.summary.Summary;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;

public class Summarizer {
    private static final Category log = Category.getInstance((Class)Summarizer.class);
    private static final int DEFAULT_SUM_CONTEXT = 10;
    private static final int DEFAULT_SUM_LENGTH = 30;
    private Analyzer analyzer;
    private StandardAnalyzer standardAnalyzer = new StandardAnalyzer();
    private int sumContext = 10;
    private int sumLength = 30;
    private LuceneConnection luceneConnection;

    public Summarizer() {
    }

    public Summarizer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public Summarizer(Analyzer analyzer, int sumContext, int sumLength, LuceneConnection luceneConnection) {
        this.analyzer = analyzer;
        this.sumContext = sumContext;
        this.sumLength = sumLength;
        this.luceneConnection = luceneConnection;
    }

    public Summary getSummary(String text) throws IOException {
        return this.getSummary(text, null);
    }

    public Summary getSummary(String text, String query) throws IOException {
        log.debug((Object)("\n\ntext = " + text));
        log.debug((Object)("query = " + query));
        Token[] tokens = this.parseText(text);
        if (log.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < tokens.length; ++i) {
                buf.append(tokens[i].termText());
                if (i == tokens.length - 1) continue;
                buf.append(", ");
            }
            log.debug((Object)"tokens = ");
        }
        if (tokens.length == 0) {
            return new Summary();
        }
        Set highlight = this.getTerms(query);
        log.debug((Object)("highlight = " + highlight));
        TreeSet<Excerpt> excerptSet = new TreeSet<Excerpt>(new Comparator(){

            public int compare(Object o1, Object o2) {
                int numToks2;
                Excerpt excerpt1 = (Excerpt)o1;
                Excerpt excerpt2 = (Excerpt)o2;
                if (excerpt1 == null && excerpt2 != null) {
                    return -1;
                }
                if (excerpt1 != null && excerpt2 == null) {
                    return 1;
                }
                if (excerpt1 == null && excerpt2 == null) {
                    return 0;
                }
                int numToks1 = excerpt1.numUniqueTokens();
                if (numToks1 < (numToks2 = excerpt2.numUniqueTokens())) {
                    return -1;
                }
                if (numToks1 == numToks2) {
                    return excerpt1.numFragments() - excerpt2.numFragments();
                }
                return 1;
            }
        });
        int lastExcerptPos = 0;
        if (highlight.size() > 0) {
            for (int i = 0; i < tokens.length; ++i) {
                if (!highlight.contains(tokens[i].termText())) continue;
                int startToken = i > this.sumContext ? i - this.sumContext : 0;
                int endToken = Math.min(i + this.sumContext, tokens.length);
                int offset = tokens[startToken].startOffset();
                int j = startToken;
                Excerpt excerpt = new Excerpt();
                if (offset != 0) {
                    excerpt.add(new Summary.Ellipsis());
                }
                while (j < endToken && j - startToken < this.sumLength) {
                    Token t = tokens[j];
                    if (highlight.contains(t.termText())) {
                        excerpt.addToken(t.termText());
                        excerpt.add(new Summary.Fragment(text.substring(offset, t.startOffset())));
                        excerpt.add(new Summary.Highlight(text.substring(t.startOffset(), t.endOffset())));
                        offset = t.endOffset();
                        endToken = Math.min(j + this.sumContext, tokens.length);
                    }
                    ++j;
                }
                lastExcerptPos = endToken;
                if (j < tokens.length) {
                    excerpt.add(new Summary.Fragment(text.substring(offset, tokens[j].endOffset())));
                }
                excerpt.setNumTerms(j - startToken);
                excerptSet.add(excerpt);
                i = j + this.sumContext;
            }
        }
        if (excerptSet.size() == 0) {
            int excerptLen;
            Excerpt excerpt = new Excerpt();
            lastExcerptPos = excerptLen = Math.min(this.sumLength, tokens.length);
            excerpt.add(new Summary.Fragment(text.substring(tokens[0].startOffset(), tokens[excerptLen - 1].endOffset())));
            excerpt.setNumTerms(excerptLen);
            excerptSet.add(excerpt);
        }
        log.debug((Object)("Found excerpts = " + excerptSet.size()));
        double tokenCount = 0.0;
        Summary s = new Summary();
        while (tokenCount <= (double)this.sumLength && excerptSet.size() > 0) {
            Excerpt excerpt = (Excerpt)excerptSet.last();
            excerptSet.remove(excerpt);
            double tokenFraction = 1.0 * (double)excerpt.getNumTerms() / (double)excerpt.numFragments();
            Enumeration e = excerpt.elements();
            while (e.hasMoreElements()) {
                Summary.Fragment f = (Summary.Fragment)e.nextElement();
                if (tokenCount + tokenFraction <= (double)this.sumLength) {
                    s.add(f);
                }
                tokenCount += tokenFraction;
            }
        }
        if (tokenCount > 0.0 && lastExcerptPos < tokens.length) {
            s.add(new Summary.Ellipsis());
        }
        return s;
    }

    private Set getTerms(String query) {
        if (StringUtils.isNotEmpty((String)query)) {
            try {
                HashSet<String> tokens = new HashSet<String>();
                if (this.luceneConnection != null && query.indexOf(42) > -1) {
                    QueryParser qp = new QueryParser("contentBody", (Analyzer)this.standardAnalyzer);
                    try {
                        final Query parsed = qp.parse(query);
                        final String[] queryTemp = new String[1];
                        this.luceneConnection.withReader(new ILuceneConnection.ReaderAction(){

                            public Object perform(IndexReader reader) throws IOException {
                                Query q = parsed.rewrite(reader);
                                queryTemp[0] = q.toString().replaceAll("contentBody:", "");
                                return null;
                            }
                        });
                        String[] terms = queryTemp[0].split(" ");
                        for (int i = 0; i < terms.length; ++i) {
                            tokens.add(terms[i]);
                        }
                    }
                    catch (ParseException e) {
                        log.warn((Object)("Error encountered parsing query: " + query + " for wildcard match."), (Throwable)e);
                    }
                }
                TokenStream ts = this.analyzer.tokenStream("contentBody", (Reader)new StringReader(query));
                Token token = ts.next();
                while (token != null) {
                    tokens.add(token.termText());
                    token = ts.next();
                }
                return tokens;
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return Collections.EMPTY_SET;
    }

    private Token[] parseText(String text) throws IOException {
        if (text == null || text.trim().equals("")) {
            return new Token[0];
        }
        ArrayList<Token> result = new ArrayList<Token>();
        TokenStream ts = this.analyzer.tokenStream("contentBody", (Reader)new StringReader(text));
        Token token = ts.next();
        while (token != null) {
            result.add(token);
            token = ts.next();
        }
        return result.toArray(new Token[result.size()]);
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void setSumContext(int sumContext) {
        this.sumContext = sumContext;
    }

    public void setSumLength(int sumLength) {
        this.sumLength = sumLength;
    }

    public void setAnalyzerFactory(LuceneAnalyzerFactory f) {
        this.analyzer = f.createAnalyzer();
    }

    public void setLuceneConnection(LuceneConnection luceneConnection) {
        this.luceneConnection = luceneConnection;
    }
}

