/*
 * Decompiled with CFR 0.152.
 */
package bucket.core.persistence.hibernate;

import bucket.core.persistence.EntityObjectQueue;
import bucket.core.persistence.hibernate.AnyTypeHibernateObjectDao;
import bucket.core.persistence.hibernate.HibernateHandle;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class HibernateEntityObjectQueue
implements EntityObjectQueue {
    public static final Category log = Category.getInstance((Class)HibernateEntityObjectQueue.class);
    private List handles;
    private SessionFactory sessionFactory;

    public HibernateEntityObjectQueue(List handles, SessionFactory sessionFactory) throws HibernateException {
        this.handles = handles;
        this.sessionFactory = sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getNextObjects() {
        ArrayList<Long> idsToCollect = new ArrayList<Long>(10);
        String className = null;
        List list = this.handles;
        synchronized (list) {
            Iterator it = this.handles.iterator();
            while (it.hasNext() && idsToCollect.size() < 10) {
                HibernateHandle handle = (HibernateHandle)it.next();
                if (className != null && !className.equals(handle.getClassName())) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Collecting: " + handle));
                }
                className = handle.getClassName();
                idsToCollect.add(new Long(handle.getId()));
                it.remove();
            }
        }
        try {
            if (idsToCollect.size() > 0) {
                return this.getObjects(idsToCollect, className);
            }
        }
        catch (HibernateException e) {
            AnyTypeHibernateObjectDao.log.error((Object)("Unable to get objects: " + e.getMessage()), (Throwable)e);
        }
        return new ArrayList(0);
    }

    public void clearCaches() {
        this.getSession().clear();
    }

    public void close() {
    }

    private List getObjects(List idsToCollect, String className) throws HibernateException {
        return this.getSession().find("from " + className + " s where s.id = " + TextUtils.join((String)" or s.id = ", (Collection)idsToCollect));
    }

    private Session getSession() {
        return SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)false);
    }
}

