/*
 * Decompiled with CFR 0.152.
 */
package bucket.user;

import bucket.user.UserAccessor;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.core.user.preferences.UserPreferences;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.ExternalEntity;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.Configuration;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.impl.delegation.repository.DelegatingRepository;
import com.atlassian.user.properties.PropertySetFactory;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.DefaultSearchResult;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.query.EmailTermQuery;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.QueryContext;
import com.atlassian.user.security.authentication.Authenticator;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class DefaultUserAccessor
implements UserAccessor {
    private static final Logger log = Logger.getLogger((Class)DefaultUserAccessor.class);
    public Group defaultGroup;
    public final String DEFAULT_GROUP_NAME = "users";
    private Configuration atlassianUserConfiguration;

    public RepositoryIdentifier getRepository(Entity entity) throws EntityException {
        RepositoryIdentifier identifier = null;
        if (entity instanceof User) {
            identifier = this.getUserManager().getRepository(entity);
        } else if (entity instanceof Group) {
            identifier = this.getGroupManager().getRepository(entity);
        } else if (entity instanceof ExternalEntity) {
            identifier = this.getUserManager().getRepository(entity);
        }
        if (identifier == null) {
            log.error((Object)("Could not identify repository for externalEntity: [" + (entity == null ? "null" : entity.getName()) + "]"));
        }
        return identifier;
    }

    public User addUser(String username, String password, String email, String fullname, String[] groups) {
        User user;
        try {
            user = this.addUser(username, password, email, fullname);
            if (groups != null) {
                for (int i = 0; i < groups.length; ++i) {
                    Group group = this.getGroupCreateIfNecessary(groups[i]);
                    this.getGroupManager().addMembership(group, user);
                }
            }
            this.getUserManager().saveUser(user);
        }
        catch (EntityException e) {
            throw new InfrastructureException((Throwable)e);
        }
        return user;
    }

    public User addUser(String username, String password, String email, String fullname) {
        try {
            User user = this.getUserManager().createUser(username.toLowerCase());
            this.getUserManager().alterPassword(user, password);
            user.setEmail(email);
            user.setFullName(fullname);
            this.getUserManager().saveUser(user);
            return user;
        }
        catch (EntityException e) {
            throw new InfrastructureException((Throwable)e);
        }
    }

    public Pager getUserNames() {
        Pager pager = null;
        try {
            pager = this.getUserManager().getUserNames();
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return pager;
    }

    public Pager getUsers() {
        Pager pager = null;
        try {
            pager = this.getUserManager().getUsers();
        }
        catch (EntityException e) {
            log.error((Object)("Error in getUsers():" + e.getMessage()), (Throwable)e);
        }
        return pager;
    }

    public User getUser(String name) {
        if (!TextUtils.stringSet((String)name)) {
            return null;
        }
        User user = null;
        try {
            user = this.getUserManager().getUser(name);
        }
        catch (EntityException e) {
            try {
                user = this.getUserManager().getUser(name.toLowerCase());
            }
            catch (EntityException e1) {
                log.error((Object)("Error in getUser():" + e1.getMessage()), (Throwable)e1);
            }
        }
        return user;
    }

    public Pager getGroups() {
        Pager pager = null;
        try {
            pager = this.getGroupManager().getGroups();
        }
        catch (EntityException e) {
            log.error((Object)("Error in getGroups():" + e.getMessage()), (Throwable)e);
        }
        return pager;
    }

    public Group addGroup(String name) {
        if (!TextUtils.stringSet((String)name)) {
            throw new IllegalArgumentException("Invalid group name specified.");
        }
        try {
            return this.getGroupManager().createGroup(name.toLowerCase());
        }
        catch (EntityException e) {
            throw new InfrastructureException(e.getMessage());
        }
    }

    public void removeGroup(Group group) {
        try {
            this.getGroupManager().removeGroup(group);
        }
        catch (EntityException e) {
            throw new InfrastructureException(e.getMessage());
        }
    }

    public void removeUser(User user) {
        try {
            this.getUserManager().removeUser(user);
        }
        catch (EntityException e) {
            throw new InfrastructureException(e.getMessage());
        }
    }

    public void saveUser(User user) {
        try {
            this.getUserManager().saveUser(user);
        }
        catch (EntityException e) {
            throw new InfrastructureException(e.getMessage());
        }
    }

    public void init(HashMap hashMap) {
    }

    public SearchResult findUsers(Query query) throws EntityException {
        return this.getEntityQueryParser().findUsers(query);
    }

    public SearchResult findGroups(Query query) throws EntityException {
        return this.getEntityQueryParser().findGroups(query);
    }

    public SearchResult findUsers(Query query, QueryContext context) throws EntityException {
        return this.getEntityQueryParser().findUsers(query);
    }

    public SearchResult findGroups(Query query, QueryContext context) throws EntityException {
        return this.getEntityQueryParser().findGroups(query);
    }

    public SearchResult getUsersByEmail(String email) {
        if (!TextUtils.stringSet((String)email)) {
            return new DefaultSearchResult();
        }
        SearchResult results = null;
        EmailTermQuery emailQuery = new EmailTermQuery(email);
        try {
            results = this.getEntityQueryParser().findUsers((Query)emailQuery);
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage());
        }
        return results;
    }

    public Group getGroup(String name) {
        if (!TextUtils.stringSet((String)name)) {
            return null;
        }
        Group group = null;
        try {
            group = this.getGroupManager().getGroup(name);
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage());
        }
        return group;
    }

    public Group getGroupCreateIfNecessary(String name) {
        Group group;
        if (!TextUtils.stringSet((String)name)) {
            throw new IllegalArgumentException("Invalid group name specified");
        }
        try {
            group = this.getGroupManager().getGroup(name);
            if (group == null) {
                group = this.getGroupManager().createGroup(name);
            }
        }
        catch (EntityException e) {
            log.error((Object)("Failed to retrieve or create group: " + name), (Throwable)e);
            throw new InfrastructureException("Failed to retrieve or create group: " + name, (Throwable)e);
        }
        return group;
    }

    public UserPreferences getUserPreferences(User user) {
        if (user == null) {
            return null;
        }
        UserPreferences pref = null;
        try {
            pref = new UserPreferences(this.getPropertySetFactory().getPropertySet((Entity)user));
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage());
        }
        return pref;
    }

    protected void removeUserFromAllGroups(User user) {
        try {
            Iterator iter = this.getGroupManager().getGroups().iterator();
            while (iter.hasNext()) {
                this.getGroupManager().removeMembership((Group)iter.next(), user);
            }
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage());
        }
    }

    public void deactivateUser(User user) {
        try {
            this.getPropertySetFactory().getPropertySet((Entity)user).setBoolean("confluence.user.deactivated", true);
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage());
        }
    }

    public void reactivateUser(User user) {
        try {
            this.getPropertySetFactory().getPropertySet((Entity)user).setBoolean("confluence.user.deactivated", false);
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage());
        }
    }

    public Pager getUsersWithConfluenceAccess() {
        Pager pager = this.getUsers();
        ArrayList<User> activeUsers = new ArrayList<User>();
        while (pager.iterator().hasNext()) {
            User user = (User)pager.iterator().next();
            try {
                if (this.getPropertySetFactory().getPropertySet((Entity)user).getBoolean("confluence.user.deactivated")) continue;
                activeUsers.add(user);
            }
            catch (EntityException e) {
                log.error((Object)e.getMessage());
            }
        }
        return new DefaultPager(activeUsers);
    }

    public boolean isLicensedToAddMoreUsers() {
        return true;
    }

    public boolean isUserRemovable(User user) throws EntityException {
        return !this.getUserManager().isReadOnly(user);
    }

    public Group getDefaultGroup() {
        if (this.defaultGroup == null) {
            this.defaultGroup = this.getGroup("users");
        }
        return this.defaultGroup;
    }

    public Pager getGroups(User user) {
        Pager pager = null;
        try {
            pager = this.getGroupManager().getGroups(user);
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            pager = new DefaultPager();
        }
        return pager;
    }

    public boolean hasMembership(Group group, User user) {
        if (group == null || user == null) {
            return false;
        }
        boolean result = false;
        try {
            result = this.getGroupManager().hasMembership(group, user);
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public boolean hasMembership(String groupname, String username) {
        try {
            Group group = this.getGroupManager().getGroup(groupname);
            if (group == null || !TextUtils.stringSet((String)username)) {
                return false;
            }
            User user = this.getUserManager().getUser(username);
            if (user == null) {
                throw new IllegalArgumentException("No such user: [" + username + "]");
            }
            return this.hasMembership(group, user);
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage());
            return false;
        }
    }

    public void addMembership(Group group, User user) {
        try {
            this.getGroupManager().addMembership(group, user);
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage());
        }
    }

    public void addMembership(String groupname, String username) {
        try {
            Group group = this.getGroupManager().getGroup(groupname);
            User user = this.getUserManager().getUser(username);
            this.addMembership(group, user);
        }
        catch (EntityException e) {
            log.error((Object)e);
        }
    }

    public boolean removeMembership(Group group, User user) {
        try {
            this.getGroupManager().removeMembership(group, user);
        }
        catch (EntityException e) {
            log.error((Object)e);
        }
        return true;
    }

    public boolean removeMembership(String groupname, String username) {
        Group group = this.getGroup(groupname);
        User user = this.getUser(username);
        if (group != null && user != null) {
            return this.removeMembership(group, user);
        }
        return false;
    }

    public PropertySet getPropertySet(User user) {
        if (user == null) {
            return null;
        }
        PropertySet ps = null;
        try {
            ps = this.getPropertySetFactory().getPropertySet((Entity)user);
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return ps;
    }

    public Pager getMemberNames(Group group) {
        Pager pager = null;
        if (group == null) {
            throw new IllegalArgumentException("There are no members in a null group");
        }
        try {
            pager = this.getGroupManager().getMemberNames(group);
        }
        catch (EntityException e) {
            log.error((Object)e);
        }
        return pager;
    }

    public Pager getLocalMembers(Group group) {
        Pager pager = null;
        try {
            pager = this.getGroupManager().getLocalMemberNames(group);
        }
        catch (EntityException e) {
            log.error((Object)e);
        }
        return pager;
    }

    public Pager getExternallMembers(Group group) {
        Pager pager = null;
        try {
            pager = this.getGroupManager().getExternalMemberNames(group);
        }
        catch (EntityException e) {
            log.error((Object)e);
        }
        return pager;
    }

    public User createUser(String username) {
        User user = null;
        try {
            user = this.getUserManager().createUser(username);
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return user;
    }

    public Group createGroup(String groupname) {
        Group group = null;
        try {
            group = this.getGroupManager().createGroup(groupname);
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return group;
    }

    public boolean isDeactivated(User user) {
        if (user == null) {
            return false;
        }
        boolean result = false;
        try {
            result = this.getPropertySetFactory().getPropertySet((Entity)user).getBoolean("confluence.user.deactivated");
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public boolean isDeactivated(String username) {
        User user = this.getUser(username);
        if (user != null) {
            return this.isDeactivated(user);
        }
        return false;
    }

    public boolean authenticate(String username, String password) {
        boolean result = false;
        try {
            result = this.getAuthenticator().authenticate(username, password);
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public void alterPassword(User user, String plainTextPassword) throws EntityException {
        this.getUserManager().alterPassword(user, plainTextPassword);
    }

    public List getDelegatingRepositories() {
        RepositoryIdentifier repo = this.getUserManager().getIdentifier();
        if (repo instanceof DelegatingRepository) {
            return ((DelegatingRepository)repo).getRepositories();
        }
        return null;
    }

    protected UserManager getUserManager() {
        this.checkConfiguration();
        return this.atlassianUserConfiguration.getDelegationAccessor().getUserManager();
    }

    protected GroupManager getGroupManager() {
        this.checkConfiguration();
        return this.atlassianUserConfiguration.getDelegationAccessor().getGroupManager();
    }

    protected Authenticator getAuthenticator() {
        this.checkConfiguration();
        return this.atlassianUserConfiguration.getDelegationAccessor().getAuthenticator();
    }

    protected PropertySetFactory getPropertySetFactory() {
        this.checkConfiguration();
        return this.atlassianUserConfiguration.getDelegationAccessor().getPropertySetFactory();
    }

    protected EntityQueryParser getEntityQueryParser() {
        return this.atlassianUserConfiguration.getDelegationAccessor().getEntityQueryParser();
    }

    protected void checkConfiguration() {
        if (!this.atlassianUserConfiguration.isInitialized()) {
            try {
                this.atlassianUserConfiguration.init();
            }
            catch (ConfigurationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setAtlassianUserConfiguration(Configuration atlassianUserConfiguration) {
        this.atlassianUserConfiguration = atlassianUserConfiguration;
    }
}

