/*
 * Decompiled with CFR 0.152.
 */
package bucket.user.providers;

import bucket.user.providers.ChainedAccessProvider;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheManager;
import com.atlassian.core.util.PairType;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.cache.CacheFactoryAware;
import java.io.Serializable;
import java.util.Properties;
import org.apache.log4j.Category;

public class CachingAccessProvider
extends ChainedAccessProvider
implements CacheFactoryAware {
    private static String CACHE_KEY_ACCESS_PROVIDER_HANDLES = CachingAccessProvider.class.getName() + ".handles()";
    private static String CACHE_KEY_ACCESS_PROVIDER_IN_GROUP = CachingAccessProvider.class.getName() + ".inGroup()";
    private static Category log = Category.getInstance((Class)CachingAccessProvider.class);
    private Cache handlesCache;
    private Cache inGroupCache;
    protected CacheFactory cacheFactory;

    public boolean init(Properties properties) {
        boolean result = super.init(properties);
        if (ContainerManager.isContainerSetup()) {
            if (ContainerManager.getComponent((String)"cacheFactory") != null) {
                this.cacheFactory = (CacheFactory)ContainerManager.getComponent((String)"cacheFactory");
            }
            if (this.cacheFactory == null && ContainerManager.getComponent((String)"cacheManager") != null) {
                this.cacheFactory = (CacheManager)ContainerManager.getComponent((String)"cacheManager");
            }
            this.initCaches();
        }
        return result;
    }

    public boolean handles(String name) {
        try {
            Object element = this.handlesCache.get((Object)name);
            if (element != null) {
                Boolean result = (Boolean)element;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found cached handles() lookup for " + name));
                }
                return result;
            }
        }
        catch (Exception e) {
            log.error((Object)("Error accessing handlesCache:" + e), (Throwable)e);
        }
        boolean result = super.handles(name);
        this.handlesCache.put((Object)name, (Object)result);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Caching handles() result for " + name));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean create(String name) {
        Cache cache = this.handlesCache;
        synchronized (cache) {
            try {
                this.handlesCache.remove((Object)name);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            return super.create(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String name) {
        Cache cache = this.handlesCache;
        synchronized (cache) {
            try {
                this.handlesCache.remove((Object)name);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            return super.remove(name);
        }
    }

    public boolean inGroup(String username, String groupname) {
        PairType key = new PairType((Serializable)((Object)username), (Serializable)((Object)groupname));
        try {
            Object element = this.inGroupCache.get((Object)key);
            if (element != null) {
                Boolean result = (Boolean)element;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found cached inGroup() lookup for " + key));
                }
                return result;
            }
        }
        catch (Exception e) {
            log.error((Object)("Error accessing inGroupCache:" + e), (Throwable)e);
        }
        boolean result = super.inGroup(username, groupname);
        this.inGroupCache.put((Object)key, (Object)result);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Caching inGroup() result for " + key));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToGroup(String username, String groupname) {
        Cache cache = this.inGroupCache;
        synchronized (cache) {
            try {
                this.inGroupCache.remove((Object)new PairType((Serializable)((Object)username), (Serializable)((Object)groupname)));
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            return super.addToGroup(username, groupname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFromGroup(String username, String groupname) {
        Cache cache = this.inGroupCache;
        synchronized (cache) {
            try {
                this.inGroupCache.remove((Object)new PairType((Serializable)((Object)username), (Serializable)((Object)groupname)));
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            return super.removeFromGroup(username, groupname);
        }
    }

    public void flushCaches() {
        this.flushCache(this.handlesCache);
        this.flushCache(this.inGroupCache);
        super.flushCaches();
    }

    public void setCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
        this.initCaches();
    }

    private void initCaches() {
        if (this.cacheFactory != null) {
            this.handlesCache = this.cacheFactory.getCache(CACHE_KEY_ACCESS_PROVIDER_HANDLES);
            this.inGroupCache = this.cacheFactory.getCache(CACHE_KEY_ACCESS_PROVIDER_IN_GROUP);
        }
    }
}

