/*
 * Decompiled with CFR 0.152.
 */
package bucket.user.providers;

import com.opensymphony.user.Entity;
import com.opensymphony.user.provider.UserProvider;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Category;

public abstract class ChainedUserProvider
implements UserProvider {
    private Category log = Category.getInstance((Class)ChainedUserProvider.class);
    private UserProvider nextProvider;

    protected abstract Class getProviderClass();

    protected UserProvider getNextProvider() {
        return this.nextProvider;
    }

    public boolean init(Properties properties) {
        if (!properties.containsKey("chain.classname") || properties.getProperty("chain.classname").length() == 0) {
            this.log.error((Object)"ChainedUserProvider requires a 'chain.classname' init property to determine next class in chain");
            return false;
        }
        try {
            Class<?> next = Class.forName(properties.getProperty("chain.classname"));
            if (!this.getProviderClass().isAssignableFrom(next)) {
                this.log.error((Object)("Configured chained class " + next.getName() + " is not of expected type " + this.getProviderClass().getName()));
                return false;
            }
            this.nextProvider = (UserProvider)next.newInstance();
            return this.nextProvider.init(this.extractChainedProperties(properties));
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to instantiate chained access provider class " + properties.getProperty("chain.classname")), (Throwable)e);
            return false;
        }
    }

    private Properties extractChainedProperties(Properties properties) {
        Properties newProps = new Properties();
        Iterator<Map.Entry<Object, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            String key = (String)entry.getKey();
            if (!key.startsWith("chain.") || key.equals("chain.classname") || key.length() <= 6) continue;
            newProps.put(key.substring(6), entry.getValue());
        }
        return newProps;
    }

    public boolean create(String s) {
        return this.getNextProvider().create(s);
    }

    public void flushCaches() {
        this.getNextProvider().flushCaches();
    }

    public boolean handles(String s) {
        return this.getNextProvider().handles(s);
    }

    public List list() {
        return this.getNextProvider().list();
    }

    public boolean load(String s, Entity.Accessor accessor) {
        return this.getNextProvider().load(s, accessor);
    }

    public boolean remove(String s) {
        return this.getNextProvider().remove(s);
    }

    public boolean store(String s, Entity.Accessor accessor) {
        return this.getNextProvider().store(s, accessor);
    }
}

