/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.quartz.jobs;

import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.TaskQueue;
import com.atlassian.quartz.jobs.AbstractJob;
import org.apache.log4j.Category;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class TaskQueueFlushJob
extends AbstractJob {
    private static Category log = Category.getInstance((Class)TaskQueueFlushJob.class);
    private MultiQueueTaskManager taskManager;

    public void setTaskManager(MultiQueueTaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public void doExecute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        TaskQueue queue = this.getTaskQueue(this.getQueueName());
        if (queue != null && !queue.isFlushing()) {
            log.debug((Object)("Executing tasks for queue: " + this.getQueueName()));
            queue.flush();
        } else {
            log.debug((Object)"Task Queue was already being flushed - skipped this time.");
        }
    }

    protected String getQueueName() {
        return "task";
    }

    protected TaskQueue getTaskQueue(String name) {
        TaskQueue queue = this.taskManager.getTaskQueue(name);
        if (queue == null) {
            throw new IllegalArgumentException("Task queue with name '" + name + "' does not exist");
        }
        return queue;
    }
}

