/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upgrade;

import bucket.core.persistence.hibernate.schema.SchemaHelper;
import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.ConfigurationException;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventType;
import com.atlassian.upgrade.BuildNumComparator;
import com.atlassian.upgrade.DatabaseUpgradeTask;
import com.atlassian.upgrade.UpgradeException;
import com.atlassian.upgrade.UpgradeManager;
import com.atlassian.upgrade.UpgradeTask;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractUpgradeManager
implements UpgradeManager {
    protected static final Logger log = Logger.getLogger((Class)AbstractUpgradeManager.class);
    private ApplicationConfiguration applicationConfig;
    private SchemaHelper schemaHelper;
    private List upgradeTasks = new ArrayList();
    private List preSchemaUpgradeTasks = new ArrayList();
    private List schemaUpgradeTasks = new ArrayList();
    private List errors = new ArrayList();
    private boolean upgraded = true;
    protected Comparator buildNumberComp = new BuildNumComparator();

    public void setApplicationConfig(ApplicationConfiguration applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    public void setSchemaHelper(SchemaHelper schemaHelper) {
        this.schemaHelper = schemaHelper;
    }

    public void upgrade(JohnsonEventContainer agentJohnson) throws UpgradeException {
        try {
            if (this.isUpgradeAllowed()) {
                boolean needUpgrade = this.needUpgrade();
                if (Boolean.getBoolean("atlassian.forceSchemaUpdate") || needUpgrade) {
                    this.upgradeSchema();
                }
                if (needUpgrade) {
                    this.upgradeStarted();
                    this.doUpgrade();
                    this.upgradeFinished();
                }
                this.upgraded = true;
            } else {
                this.upgraded = false;
                this.addJohnsonEvent(agentJohnson, "Cannot proceed with upgrade. Your current license does not entitle you to upgrade to this version of Confluence. Please check that the support period of your license has not expired or that you have the correct partner license. If you wish to renew your license, please contact sales@atlassian.com. If you have a new license, please enter it on this <a href='fixonly/fixlicense.action'>page</a> and <b>restart</b>.");
            }
        }
        catch (UpgradeException e) {
            this.upgraded = false;
            this.addJohnsonEvent(agentJohnson);
            throw e;
        }
        catch (Throwable e) {
            this.upgraded = false;
            log.error((Object)("Exception thrown during upgrade: " + e.getMessage()), e);
            this.addJohnsonEvent(agentJohnson);
            throw new UpgradeException(e);
        }
    }

    protected void doUpgrade() throws Throwable {
        try {
            String localConfigurationBuildNumber = this.getConfiguredBuildNumber();
            String databaseBuildNumber = this.getDatabaseBuildNumber();
            List upgradeTasks = this.getUpgradeTasks();
            Iterator iterator = upgradeTasks.iterator();
            while (iterator.hasNext()) {
                boolean patchBuildGreaterThanDatabase;
                UpgradeTask upgradeTask = (UpgradeTask)iterator.next();
                boolean patchBuildGreaterThanCurrent = this.buildNumberComp.compare(localConfigurationBuildNumber, upgradeTask.getBuildNumber()) < 0;
                boolean bl = patchBuildGreaterThanDatabase = this.buildNumberComp.compare(databaseBuildNumber, upgradeTask.getBuildNumber()) < 0;
                if (!patchBuildGreaterThanCurrent) continue;
                try {
                    if (upgradeTask instanceof DatabaseUpgradeTask) {
                        if (patchBuildGreaterThanDatabase && this.permitDatabaseUpgrades()) {
                            upgradeTask.doUpgrade();
                        } else {
                            ((DatabaseUpgradeTask)upgradeTask).doNonDatabaseUpgrade();
                        }
                    } else {
                        upgradeTask.doUpgrade();
                    }
                    this.upgradeTaskSucceeded(upgradeTask);
                }
                catch (Exception e) {
                    this.upgradeTaskFailed(upgradeTask, e);
                    throw e;
                }
                finally {
                    if (upgradeTask.getErrors() != null) {
                        this.errors.addAll(upgradeTask.getErrors());
                    }
                    this.postUpgrade();
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)("Upgrade failed: " + e.getMessage()), e);
            throw new UpgradeException(e);
        }
    }

    protected void upgradeSchema() {
        try {
            this.runUpgradeTasksAndSwallowErrors(this.preSchemaUpgradeTasks);
            this.schemaHelper.updateSchemaIfNeeded();
            this.runUpgradeTasksAndSwallowErrors(this.getSchemaUpgradeTasks());
        }
        catch (Throwable t) {
            log.fatal((Object)"Could not update schema.", t);
        }
    }

    private void runUpgradeTasksAndSwallowErrors(List upgradeTasks) {
        String currentBuildNumber = this.getConfiguredBuildNumber();
        Iterator iterator = upgradeTasks.iterator();
        while (iterator.hasNext()) {
            UpgradeTask upgradeTask = (UpgradeTask)iterator.next();
            boolean patchBuildGreaterThanCurrent = this.buildNumberComp.compare(currentBuildNumber, upgradeTask.getBuildNumber()) < 0;
            if (!patchBuildGreaterThanCurrent) continue;
            try {
                upgradeTask.doUpgrade();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    protected void upgradeTaskSucceeded(UpgradeTask upgradeTask) throws ConfigurationException {
        this.setConfiguredBuildNumber(upgradeTask.getBuildNumber());
    }

    protected void upgradeTaskFailed(UpgradeTask upgradeTask, Throwable e) {
        if (upgradeTask.getErrors() == null || upgradeTask.getErrors().size() == 0) {
            this.errors.add(e.getMessage());
        }
    }

    private void addJohnsonEvent(JohnsonEventContainer johnson) {
        this.addJohnsonEvent(johnson, "Upgrade failed. Please consult the system logs for details. You will need to fix these problems and restart.");
    }

    private void addJohnsonEvent(JohnsonEventContainer johnson, String message) {
        if (johnson != null) {
            johnson.addEvent(new Event(EventType.get((String)"upgrade"), message, "fatal"));
        }
    }

    protected void upgradeStarted() throws Exception {
    }

    public void setPreSchemaUpgradeTasks(List preSchemaUpgradeTasks) {
        this.preSchemaUpgradeTasks = preSchemaUpgradeTasks;
    }

    public void setUpgradeTasks(List upgradeTasks) {
        this.upgradeTasks = upgradeTasks;
    }

    public List getUpgradeTasks() {
        return this.upgradeTasks;
    }

    public void setSchemaUpgradeTasks(List upgradeTasks) {
        this.schemaUpgradeTasks = upgradeTasks;
    }

    public List getSchemaUpgradeTasks() {
        return this.schemaUpgradeTasks;
    }

    public List getErrors() {
        return this.errors;
    }

    public boolean isUpgradeAllowed() {
        return true;
    }

    protected String getConfiguredBuildNumber() {
        return this.applicationConfig.getBuildNumber();
    }

    protected void setConfiguredBuildNumber(String buildNumber) throws ConfigurationException {
        this.applicationConfig.setBuildNumber(buildNumber);
        this.applicationConfig.save();
    }

    public boolean needUpgrade() {
        boolean afterSetup = this.applicationConfig.isSetupComplete();
        try {
            int realBuildNumber = Integer.parseInt(this.getRealBuildNumber());
            int configuredBuildNumber = Integer.parseInt(this.getConfiguredBuildNumber());
            boolean differentBuildNumbers = realBuildNumber != configuredBuildNumber;
            return afterSetup && differentBuildNumbers;
        }
        catch (NumberFormatException e) {
            log.warn((Object)"Build numbers are not parseable. Upgrade skipped");
            return false;
        }
    }

    protected void upgradeFinished() throws Exception {
        if (this.errors.isEmpty()) {
            this.setDatabaseBuildNumber(this.getRealBuildNumber());
            this.applicationConfig.setBuildNumber(this.getRealBuildNumber());
            this.applicationConfig.save();
        }
    }

    protected abstract String getRealBuildNumber();

    protected abstract String getDatabaseBuildNumber();

    protected abstract void setDatabaseBuildNumber(String var1) throws Exception;

    protected boolean permitDatabaseUpgrades() throws UpgradeException {
        return true;
    }

    protected void postUpgrade() {
    }

    public boolean isUpgraded() {
        return this.upgraded;
    }
}

