/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.config.wizard;

import com.atlassian.config.ConfigurationException;
import com.atlassian.config.wizard.SaveStrategy;
import com.atlassian.config.wizard.SetupStep;
import com.atlassian.config.wizard.StepNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SetupWizard {
    private List steps = new ArrayList();
    private SetupStep currentStep = null;
    private SaveStrategy saveStrategy = null;

    public void addStep(SetupStep step) {
        this.addStep(step, this.steps.size());
    }

    public void addStep(SetupStep step, int index) {
        step.setIndex(index);
        this.steps.add(index, step);
    }

    public SetupStep getCurrentStep() {
        if (this.currentStep == null && this.steps.size() > 0) {
            this.currentStep = this.getStep(0);
        }
        return this.currentStep;
    }

    protected void setCurrentStep(SetupStep step) {
        this.currentStep = step;
    }

    public String getStepNameByIndex(int index) {
        if (index >= this.steps.size()) {
            return null;
        }
        return ((SetupStep)this.steps.get(index)).getName();
    }

    public int getStepIndexByName(String name) {
        Iterator iterator = this.steps.iterator();
        while (iterator.hasNext()) {
            SetupStep setupStep = (SetupStep)iterator.next();
            if (!setupStep.getName().equals(name)) continue;
            return setupStep.getIndex();
        }
        return -1;
    }

    public boolean isSetupStepFinished(String stepName) throws StepNotFoundException {
        return this.isStepBeforeCurrentStep(stepName);
    }

    private boolean isStepBeforeCurrentStep(String stepName) throws StepNotFoundException {
        int pos = this.getStepIndexByName(stepName);
        if (pos == -1) {
            throw new StepNotFoundException(stepName);
        }
        return pos < this.getCurrentStep().getIndex();
    }

    public boolean isSetupComplete() {
        return this.steps.size() - 1 == this.getCurrentStep().getIndex();
    }

    public void previous() throws ConfigurationException {
        if (this.getCurrentStep().getIndex() > 0) {
            int index = this.getCurrentStep().getIndex() - 1;
            this.setCurrentStep((SetupStep)this.steps.get(index));
            this.getCurrentStep().onStart();
            this.save();
        }
    }

    public void next() throws ConfigurationException {
        if (!this.isSetupComplete()) {
            int nextIndex = this.getCurrentStep().getIndex() + 1;
            this.getCurrentStep().onNext();
            this.setCurrentStep((SetupStep)this.steps.get(nextIndex));
            this.getCurrentStep().onStart();
            this.save();
        }
    }

    public void next(String stepName) throws StepNotFoundException, ConfigurationException {
        int step = this.getStepIndexByName(stepName);
        if (step == -1) {
            throw new StepNotFoundException(stepName);
        }
        if (this.getCurrentStep() != null) {
            this.getCurrentStep().onNext();
        }
        this.setCurrentStep((SetupStep)this.steps.get(step));
        this.getCurrentStep().onStart();
        this.save();
    }

    public void start() throws StepNotFoundException, ConfigurationException {
        if (this.steps.size() == 0) {
            throw new StepNotFoundException("There are no steps associated with this wizard");
        }
        this.currentStep = (SetupStep)this.steps.get(0);
        this.currentStep.onStart();
        this.save();
    }

    public void finish() throws ConfigurationException {
        try {
            String current = this.getStepNameByIndex(this.steps.size() - 1);
            if (!current.equals(this.getCurrentStep().getName())) {
                this.next(current);
            } else {
                this.getCurrentStep().onNext();
                this.save();
            }
        }
        catch (StepNotFoundException stepNotFoundException) {
            // empty catch block
        }
    }

    protected synchronized void save() throws ConfigurationException {
        if (this.saveStrategy != null) {
            this.saveStrategy.save(this);
        }
    }

    public SaveStrategy getSaveStrategy() {
        return this.saveStrategy;
    }

    public void setSaveStrategy(SaveStrategy saveStrategy) {
        this.saveStrategy = saveStrategy;
    }

    public SetupStep getStep(String name) {
        int index = this.getStepIndexByName(name);
        return this.getStep(index);
    }

    public SetupStep getStep(int index) {
        if (index == -1) {
            return null;
        }
        return (SetupStep)this.steps.get(index);
    }
}

