/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.util;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.core.util.zip.FolderArchiver;
import com.opensymphony.util.TextUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class FileUtils {
    private static final Logger log = Logger.getLogger((Class)FileUtils.class);
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static int copy(InputStream input, OutputStream output) throws IOException {
        return FileUtils.copy(input, output, 4096);
    }

    public static int copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static void shutdownStream(OutputStream output) {
        if (output == null) {
            return;
        }
        try {
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void shutdownStream(InputStream input) {
        if (input == null) {
            return;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean deleteDir(File dir) {
        File candir;
        if (dir == null) {
            return false;
        }
        try {
            candir = dir.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        if (!candir.equals(dir.getAbsoluteFile())) {
            return false;
        }
        File[] files = candir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                boolean deleted;
                File file = files[i];
                boolean bl = deleted = !file.delete();
                if (!deleted || !file.isDirectory()) continue;
                FileUtils.deleteDir(file);
            }
        }
        return dir.delete();
    }

    public static void recursiveDelete(File file) {
        File[] files = null;
        if (!file.isDirectory()) {
            file.delete();
            return;
        }
        files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File next = files[i];
            FileUtils.recursiveDelete(next);
        }
        file.delete();
    }

    public static String getResourceContent(String resource) {
        InputStream is = ClassLoaderUtils.getResourceAsStream(resource, FileUtils.class);
        return FileUtils.getInputStreamTextContent(is);
    }

    public static String getResourceContent(HttpServletRequest req, String resource) {
        InputStream is = req.getSession().getServletContext().getResourceAsStream(resource);
        String result = FileUtils.getInputStreamTextContent(is);
        if (result == null) {
            result = "";
        }
        return result;
    }

    public static String getInputStreamTextContent(InputStream is) {
        if (is == null) {
            return null;
        }
        String result = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(is.available());
            FileUtils.copy(is, baos);
            result = new String(baos.toByteArray());
            is.close();
        }
        catch (IOException e) {
            log.error((Object)("IOException reading stream: " + e), (Throwable)e);
        }
        return result;
    }

    public static void saveTextFile(String stringContent, File destFile) throws IOException {
        FileUtils.ensureFileAndPathExist(destFile);
        FileWriter writer = new FileWriter(destFile);
        writer.write(stringContent);
        writer.close();
    }

    public static void ensureFileAndPathExist(File file) throws IOException {
        file.getParentFile().mkdirs();
        file.createNewFile();
    }

    public static boolean moveDir(File dirName, File destDir) {
        File destParent = new File(destDir.getParent());
        if (destDir.exists()) {
            destDir.delete();
        }
        destParent.mkdirs();
        return dirName.renameTo(destDir);
    }

    public static void createZipFile(File baseDir, File zipFile) throws Exception {
        FolderArchiver compressor = new FolderArchiver(baseDir, zipFile);
        compressor.doArchive();
    }

    public static List readResourcesAsList(String resource) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String s;
            InputStream is = ClassLoaderUtils.getResourceAsStream(resource, FileUtils.class);
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            while ((s = in.readLine()) != null) {
                String niceS = TextUtils.noNull((String)s).trim();
                if (!TextUtils.stringSet((String)niceS) || niceS.charAt(0) == '#') continue;
                result.add(s);
            }
            is.close();
        }
        catch (IOException e) {
            log.error((Object)("IOException reading stream: " + e), (Throwable)e);
        }
        return result;
    }

    public static void copyDirectory(File srcDir, File destDir) throws IOException {
        FileUtils.copyDirectory(srcDir, destDir, false);
    }

    public static void copyDirectory(File srcDir, File destDir, boolean overwrite) throws IOException {
        File[] files = srcDir.listFiles();
        if (!destDir.exists()) {
            destDir.mkdirs();
        } else {
            log.debug((Object)(destDir.getAbsolutePath() + " already exists"));
        }
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                File dest = new File(destDir, file.getName());
                if (file.isFile()) {
                    FileUtils.copyFile(new FileInputStream(file), dest, overwrite);
                    continue;
                }
                FileUtils.copyDirectory(file, dest, overwrite);
            }
        }
    }

    public static void copyFile(File srcFile, File destFile) throws IOException {
        FileUtils.copyFile(srcFile, destFile, true);
    }

    public static void copyFile(File srcFile, File destFile, boolean overwrite) throws IOException {
        if (!srcFile.exists()) {
            String message = "File " + srcFile + " does not exist";
            throw new IOException(message);
        }
        FileInputStream input = new FileInputStream(srcFile);
        FileUtils.copyFile(input, destFile, overwrite);
        if (srcFile.length() != srcFile.length()) {
            String message = "Failed to copy full contents from " + srcFile + " to " + destFile;
            throw new IOException(message);
        }
    }

    public static void copyFile(InputStream srcStream, File destFile) throws IOException {
        FileUtils.copyFile(srcStream, destFile, false);
    }

    public static void copyFile(InputStream srcStream, File destFile, boolean overwrite) throws IOException {
        File parentFile = destFile.getParentFile();
        if (!parentFile.isDirectory()) {
            parentFile.mkdirs();
        }
        if (destFile.exists()) {
            if (!destFile.canWrite()) {
                String message = "Unable to open file " + destFile + " for writing.";
                throw new IOException(message);
            }
            if (overwrite) {
                log.debug((Object)("Overwriting file at: " + destFile.getAbsolutePath()));
                FileUtils.writeStreamToFile(srcStream, destFile);
            } else {
                FileUtils.shutdownStream(srcStream);
                log.warn((Object)(destFile.getAbsolutePath() + " already exists"));
            }
        } else {
            destFile.createNewFile();
            FileUtils.writeStreamToFile(srcStream, destFile);
        }
    }

    private static void writeStreamToFile(InputStream srcStream, File destFile) throws IOException {
        BufferedInputStream input = null;
        BufferedOutputStream output = null;
        try {
            int ch;
            input = new BufferedInputStream(srcStream);
            output = new BufferedOutputStream(new FileOutputStream(destFile));
            while ((ch = ((InputStream)input).read()) != -1) {
                ((OutputStream)output).write(ch);
            }
        }
        catch (IOException e) {
            try {
                log.error((Object)("Error writing stream to file: " + destFile.getAbsolutePath()));
                throw e;
            }
            catch (Throwable throwable) {
                FileUtils.shutdownStream(input);
                FileUtils.shutdownStream(output);
                throw throwable;
            }
        }
        FileUtils.shutdownStream(input);
        FileUtils.shutdownStream(output);
    }
}

