/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gzipfilter.selector;

import com.atlassian.gzipfilter.selector.GzipCompatibilitySelector;
import com.atlassian.gzipfilter.selector.GzipCompatibilitySelectorFactory;
import com.atlassian.gzipfilter.selector.UrlRewriteGzipCompatibilitySelector;
import java.io.InputStream;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.tuckey.web.filters.urlrewrite.Conf;
import org.tuckey.web.filters.urlrewrite.UrlRewriter;

public class DefaultGzipCompatibilitySelectorFactory
implements GzipCompatibilitySelectorFactory {
    private static final String DEFAULT_CONFIG_FILENAME = "/WEB-INF/urlrewrite-gzip.xml";
    private static final String INTERNAL_CONFIG_FILE = "com/atlassian/gzipfilter/urlrewrite-gzip-default.xml";
    private static final String CONFIG_FILE_INIT_PARAM = "urlrewrite.configfile";
    private UrlRewriter rewriter;

    public GzipCompatibilitySelector getSelector(FilterConfig filterConfig, HttpServletRequest request) {
        if (this.rewriter == null) {
            this.rewriter = this.getUrlRewriter(filterConfig);
        }
        return new UrlRewriteGzipCompatibilitySelector(this.rewriter, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UrlRewriter getUrlRewriter(FilterConfig filterConfig) {
        UrlRewriter urlRewriter;
        String configFileName = filterConfig.getServletContext().getInitParameter(CONFIG_FILE_INIT_PARAM);
        if (configFileName == null) {
            configFileName = DEFAULT_CONFIG_FILENAME;
        }
        InputStream is = null;
        try {
            is = filterConfig.getServletContext().getResourceAsStream(configFileName);
            if (is == null) {
                is = this.getClass().getClassLoader().getResourceAsStream(INTERNAL_CONFIG_FILE);
            }
            if (is == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(INTERNAL_CONFIG_FILE);
            }
            if (is == null) {
                throw new IllegalStateException("Cannot load default 'com/atlassian/gzipfilter/urlrewrite-gzip-default.xml' configuration from jar");
            }
            Conf conf = new Conf(filterConfig.getServletContext(), is, null);
            urlRewriter = new UrlRewriter(conf);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return urlRewriter;
    }
}

